/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.distribution.kernel;

import com.rapidminer.tools.math.distribution.EmpiricalNormalDistribution;
import com.rapidminer.tools.math.distribution.NormalDistribution;
import com.rapidminer.tools.math.distribution.kernel.KernelDistribution;
import com.rapidminer.tools.math.distribution.kernel.NormalKernel;
import java.util.TreeSet;

public class GreedyKernelDistribution
extends KernelDistribution {
    public static final long serialVersionUID = -3298190542815818L;
    private static final double DEFAULT_MINIMUM_BANDWIDTH = 0.1;
    private static final int DEFAULT_NUMBER_OF_KERNELS = 10;
    private int numberOfKernels;
    private double minBandwidth;
    private TreeSet<NormalKernel> kernels;

    public GreedyKernelDistribution() {
        this(0.1, 10);
    }

    public GreedyKernelDistribution(double minBandwidth, int numberOfKernels) {
        this.numberOfKernels = numberOfKernels;
        this.minBandwidth = minBandwidth;
        this.kernels = new TreeSet();
    }

    @Override
    public void update(double value, double weight) {
        if (!Double.isNaN(value) && !Double.isNaN(weight)) {
            boolean kernelUpdated = false;
            double bestAssignmentDistance = Double.POSITIVE_INFINITY;
            double bestMergeDistance = Double.POSITIVE_INFINITY;
            EmpiricalNormalDistribution bestAssignmentKernel = null;
            EmpiricalNormalDistribution lastKernel = null;
            EmpiricalNormalDistribution bestMergeKernel1 = null;
            NormalKernel bestMergeKernel2 = null;
            for (NormalKernel kernel : this.kernels) {
                double mergeDistance;
                double assignmentDistance = Math.abs(value - kernel.getMean());
                if (assignmentDistance == 0.0) {
                    kernel.update(value, weight);
                    kernelUpdated = true;
                    break;
                }
                if (assignmentDistance < bestAssignmentDistance) {
                    bestAssignmentDistance = assignmentDistance;
                    bestAssignmentKernel = kernel;
                }
                if (lastKernel != null && (mergeDistance = Math.abs(lastKernel.getMean() - kernel.getMean())) < bestMergeDistance) {
                    bestMergeDistance = mergeDistance;
                    bestMergeKernel1 = lastKernel;
                    bestMergeKernel2 = kernel;
                }
                lastKernel = kernel;
            }
            if (!kernelUpdated) {
                NormalKernel kernel;
                if (this.kernels.size() < this.numberOfKernels) {
                    kernel = new NormalKernel(this.minBandwidth);
                    kernel.update(value, weight);
                    this.kernels.add(kernel);
                } else if (bestAssignmentDistance < bestMergeDistance) {
                    bestAssignmentKernel.update(value, weight);
                } else {
                    bestMergeKernel1.update(bestMergeKernel2);
                    this.kernels.remove(bestMergeKernel2);
                    kernel = new NormalKernel(this.minBandwidth);
                    kernel.update(value, weight);
                    this.kernels.add(kernel);
                }
            }
        }
    }

    @Override
    public void update(double value) {
        this.update(value, 1.0);
    }

    @Override
    public String getAttributeName() {
        return null;
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public String getParameterName(int index) {
        return null;
    }

    @Override
    public double getParameterValue(int index) {
        return Double.NaN;
    }

    @Override
    public double getUpperBound() {
        double maxMean = Double.NEGATIVE_INFINITY;
        double maxStandardDeviation = 0.2;
        for (NormalKernel kernel : this.kernels) {
            double mean = kernel.getMean();
            double standardDeviation = kernel.getStandardDeviation();
            if (mean > maxMean) {
                maxMean = mean;
            }
            if (!(standardDeviation > maxStandardDeviation)) continue;
            maxStandardDeviation = standardDeviation;
        }
        return NormalDistribution.getUpperBound(maxMean, maxStandardDeviation);
    }

    @Override
    public double getLowerBound() {
        double minMean = Double.POSITIVE_INFINITY;
        double maxStandardDeviation = 0.2;
        for (NormalKernel kernel : this.kernels) {
            double mean = kernel.getMean();
            double standardDeviation = kernel.getStandardDeviation();
            if (mean < minMean) {
                minMean = mean;
            }
            if (!(standardDeviation > maxStandardDeviation)) continue;
            maxStandardDeviation = standardDeviation;
        }
        return NormalDistribution.getLowerBound(minMean, maxStandardDeviation);
    }

    @Override
    public double getTotalWeight() {
        double totalWeight = 0.0;
        for (NormalKernel kernel : this.kernels) {
            totalWeight += kernel.getTotalWeight();
        }
        return totalWeight;
    }

    @Override
    public double getProbability(double value) {
        double probability = 0.0;
        double totalWeight = 0.0;
        for (NormalKernel kernel : this.kernels) {
            probability += kernel.getTotalWeight() * kernel.getProbability(value);
            totalWeight += kernel.getTotalWeight();
        }
        return probability / totalWeight;
    }
}

