/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.distribution.kernel;

import com.rapidminer.tools.math.distribution.NormalDistribution;
import com.rapidminer.tools.math.distribution.kernel.KernelDistribution;
import java.util.HashMap;
import java.util.Map;

public class FullKernelDistribution
extends KernelDistribution {
    public static final long serialVersionUID = -3205432422815818L;
    private boolean heuristicBandwidthSelection;
    private double bandwidth = 0.2;
    private boolean recentlyUpdated;
    private HashMap<Double, Double> valueWeightMap;
    private double weightSum;
    private double minValue;
    private double maxValue;
    private static final double STANDARD_NORMAL_LOWER_BOUND = NormalDistribution.getLowerBound(0.0, 1.0);
    private static final double STANDARD_NORMAL_UPPER_BOUND = NormalDistribution.getUpperBound(0.0, 1.0);

    public FullKernelDistribution() {
        this.valueWeightMap = new HashMap();
        this.weightSum = 0.0;
        this.minValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.heuristicBandwidthSelection = true;
        this.recentlyUpdated = false;
    }

    public FullKernelDistribution(double bandwidth) {
        this.bandwidth = bandwidth;
        this.valueWeightMap = new HashMap();
        this.weightSum = 0.0;
        this.minValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.heuristicBandwidthSelection = false;
        this.recentlyUpdated = false;
    }

    @Override
    public void update(double value, double weight) {
        if (!Double.isNaN(value) && !Double.isNaN(weight)) {
            Double totalValueWeight = this.valueWeightMap.get(value);
            totalValueWeight = totalValueWeight != null ? Double.valueOf(totalValueWeight + weight) : new Double(weight);
            this.valueWeightMap.put(value, totalValueWeight);
            this.weightSum += weight;
            if (value < this.minValue) {
                this.minValue = value;
            }
            if (value > this.maxValue) {
                this.maxValue = value;
            }
            this.recentlyUpdated = true;
        }
    }

    @Override
    public void update(double value) {
        this.update(value, 1.0);
    }

    @Override
    public String getAttributeName() {
        return null;
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public String getParameterName(int index) {
        return null;
    }

    @Override
    public double getParameterValue(int index) {
        return Double.NaN;
    }

    private void updateBandwidth() {
        if (this.heuristicBandwidthSelection && this.recentlyUpdated) {
            this.bandwidth = (this.maxValue - this.minValue) / Math.sqrt(this.weightSum);
            this.recentlyUpdated = false;
        }
    }

    @Override
    public double getUpperBound() {
        this.updateBandwidth();
        return NormalDistribution.getUpperBound(this.maxValue, this.bandwidth);
    }

    @Override
    public double getLowerBound() {
        this.updateBandwidth();
        return NormalDistribution.getLowerBound(this.minValue, this.bandwidth);
    }

    @Override
    public double getTotalWeight() {
        return this.weightSum;
    }

    @Override
    public double getProbability(double value) {
        this.updateBandwidth();
        double probability = 0.0;
        for (Map.Entry<Double, Double> entry : this.valueWeightMap.entrySet()) {
            double scaledValue = (value - entry.getKey()) / this.bandwidth;
            if (scaledValue < STANDARD_NORMAL_LOWER_BOUND || scaledValue > STANDARD_NORMAL_UPPER_BOUND) continue;
            probability += NormalDistribution.getProbability(0.0, 1.0, scaledValue) * entry.getValue() / this.bandwidth;
        }
        return probability / this.weightSum;
    }
}

