/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.distribution;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.distribution.ContinuousDistribution;

public class NormalDistribution
extends ContinuousDistribution {
    private static final long serialVersionUID = -1819042904676198636L;
    private static final double BOUND_FACTOR = 5.0;
    private static final double SQRT_FACTOR = Math.sqrt(Math.PI * 2);
    protected double mean;
    protected double standardDeviation;

    public NormalDistribution(double mean, double standardDeviation) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    @Override
    public String getAttributeName() {
        return null;
    }

    public static double getProbability(double mean, double standardDeviation, double value) {
        double base = (value - mean) / standardDeviation;
        return Math.exp(-0.5 * (base * base)) / (standardDeviation * SQRT_FACTOR);
    }

    public static double getLogProbability(double mean, double standardDeviation, double value) {
        double base = (value - mean) / standardDeviation;
        return -Math.log(standardDeviation * SQRT_FACTOR) - 0.5 * (base * base);
    }

    public static final double getLowerBound(double mean, double standardDeviation) {
        return mean - 5.0 * standardDeviation;
    }

    public static final double getUpperBound(double mean, double standardDeviation) {
        return mean + 5.0 * standardDeviation;
    }

    @Override
    public double getProbability(double value) {
        return NormalDistribution.getProbability(this.mean, this.standardDeviation, value);
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getVariance() {
        return this.standardDeviation * this.standardDeviation;
    }

    @Override
    public double getLowerBound() {
        return NormalDistribution.getLowerBound(this.mean, this.standardDeviation);
    }

    @Override
    public double getUpperBound() {
        return NormalDistribution.getUpperBound(this.mean, this.standardDeviation);
    }

    @Override
    public String toString() {
        return "Normal distribution --> mean: " + Tools.formatNumber(this.mean) + ", standard deviation: " + Tools.formatNumber(this.standardDeviation);
    }

    @Override
    public int getNumberOfParameters() {
        return 2;
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "mean";
        }
        return "standard deviation";
    }

    @Override
    public double getParameterValue(int index) {
        if (index == 0) {
            return this.mean;
        }
        return this.standardDeviation;
    }
}

