/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.distribution;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.distribution.Distribution;
import java.util.ArrayList;

public class DiscreteDistribution
implements Distribution {
    private static final long serialVersionUID = 7573474548080998479L;
    private String attributeName;
    private double[] probabilities;
    private String[] valueNames;

    public DiscreteDistribution(String attributeName, double[] probabilities, String[] valueNames) {
        this.attributeName = attributeName;
        this.probabilities = probabilities;
        this.valueNames = valueNames;
    }

    @Override
    public final boolean isDiscrete() {
        return true;
    }

    @Override
    public final boolean isContinuous() {
        return false;
    }

    @Override
    public double getProbability(double value) {
        int index = (int)value;
        if (index >= 0 && index < this.probabilities.length) {
            return this.probabilities[index];
        }
        return Double.NaN;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public ArrayList<Double> getValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < this.probabilities.length; ++i) {
            values.add(Double.valueOf(i));
        }
        return values;
    }

    @Override
    public String mapValue(double value) {
        int index = (int)value;
        if (index >= 0 && index < this.valueNames.length) {
            return this.valueNames[index];
        }
        return null;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer distributionDescription = new StringBuffer();
        boolean first = true;
        for (i = 0; i < this.valueNames.length; ++i) {
            if (!first) {
                distributionDescription.append("\t");
            }
            distributionDescription.append(this.valueNames[i]);
            first = false;
        }
        first = true;
        distributionDescription.append(Tools.getLineSeparator());
        for (i = 0; i < this.valueNames.length; ++i) {
            if (!first) {
                distributionDescription.append("\t");
            }
            distributionDescription.append(Tools.formatNumber(this.probabilities[i]));
            first = false;
        }
        return distributionDescription.toString();
    }

    @Override
    public int getNumberOfParameters() {
        return this.valueNames.length;
    }

    @Override
    public String getParameterName(int index) {
        return "value=" + this.valueNames[index];
    }

    @Override
    public double getParameterValue(int index) {
        return this.probabilities[index];
    }

    public String[] getValueNames() {
        return this.valueNames;
    }
}

