/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

import com.rapidminer.tools.Tools;
import java.io.Serializable;

public class Range
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double lower;
    private double upper;

    public Range() {
        this.lower = Double.NaN;
        this.upper = Double.NaN;
    }

    public Range(double lowerBound, double upperBound) {
        if (lowerBound > upperBound) {
            // empty if block
        }
        this.lower = lowerBound;
        this.upper = upperBound;
    }

    public Range(Range valueRange) {
        if (valueRange != null) {
            this.lower = valueRange.getLower();
            this.upper = valueRange.getUpper();
        } else {
            this.lower = Double.NEGATIVE_INFINITY;
            this.upper = Double.POSITIVE_INFINITY;
        }
    }

    public void add(double value) {
        if (value < this.lower || Double.isNaN(this.lower)) {
            this.lower = value;
        }
        if (value > this.upper || Double.isNaN(this.upper)) {
            this.upper = value;
        }
    }

    public void union(Range range) {
        this.add(range.getLower());
        this.add(range.getUpper());
    }

    public boolean contains(double value) {
        return value > this.lower && value < this.upper;
    }

    public String toString() {
        if (Double.isNaN(this.lower) || Double.isNaN(this.upper)) {
            return "\u2205";
        }
        return "[" + Tools.formatIntegerIfPossible(this.lower) + " \u2013 " + Tools.formatIntegerIfPossible(this.upper) + "]";
    }

    public double getUpper() {
        return this.upper;
    }

    public double getLower() {
        return this.lower;
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    public void setRange(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public void setRange(Range theNewRange) {
        this.setRange(theNewRange.getLower(), theNewRange.getUpper());
    }

    public void setLower(double newLowerBound) {
        this.lower = newLowerBound;
    }

    public void setUpper(double newUpperBound) {
        this.upper = newUpperBound;
    }

    public boolean equals(Object range) {
        if (range instanceof Range) {
            Range other = (Range)range;
            return this.upper == other.upper && this.lower == other.lower;
        }
        return false;
    }

    public boolean contains(Range range) {
        return this.lower <= range.lower && this.upper >= range.upper;
    }
}

