/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

import java.io.Serializable;

public class KDTreeNode<T>
implements Serializable {
    private static final long serialVersionUID = -4204535347268139613L;
    private T storeValue;
    private double[] values;
    private KDTreeNode<T> lesserChild;
    private KDTreeNode<T> greaterChild;
    private int comparationDimension;

    public KDTreeNode(double[] values, T storeValue, int comparationDimension) {
        this.values = values;
        this.storeValue = storeValue;
        this.comparationDimension = comparationDimension;
    }

    public KDTreeNode<T> getNearChild(double[] compare) {
        if (compare[this.comparationDimension] < this.values[this.comparationDimension]) {
            return this.lesserChild;
        }
        return this.greaterChild;
    }

    public KDTreeNode<T> getFarChild(double[] compare) {
        if (compare[this.comparationDimension] >= this.values[this.comparationDimension]) {
            return this.lesserChild;
        }
        return this.greaterChild;
    }

    public boolean hasNearChild(double[] compare) {
        if (compare[this.comparationDimension] < this.values[this.comparationDimension]) {
            return this.lesserChild != null;
        }
        return this.greaterChild != null;
    }

    public boolean hasFarChild(double[] compare) {
        if (compare[this.comparationDimension] >= this.values[this.comparationDimension]) {
            return this.lesserChild != null;
        }
        return this.greaterChild != null;
    }

    public void setChild(KDTreeNode<T> node) {
        if (node.getValues()[this.comparationDimension] < this.values[this.comparationDimension]) {
            this.lesserChild = node;
        } else {
            this.greaterChild = node;
        }
    }

    public T getStoreValue() {
        return this.storeValue;
    }

    public KDTreeNode getLesserChild() {
        return this.lesserChild;
    }

    public void setLesserChild(KDTreeNode<T> leftChild) {
        this.lesserChild = leftChild;
    }

    public KDTreeNode<T> getGreaterChild() {
        return this.greaterChild;
    }

    public void setGreaterChild(KDTreeNode<T> rightChild) {
        this.greaterChild = rightChild;
    }

    public double[] getValues() {
        return this.values;
    }

    public double getCompareValue() {
        return this.values[this.comparationDimension];
    }

    public int getCompareDimension() {
        return this.comparationDimension;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < this.comparationDimension; ++i) {
            buffer.append(this.values[i] + "  ");
        }
        buffer.append("[");
        buffer.append(this.values[this.comparationDimension]);
        buffer.append("]  ");
        for (i = this.comparationDimension + 1; i < this.values.length; ++i) {
            buffer.append(this.values[i] + "  ");
        }
        return buffer.toString();
    }
}

