/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.tools.math.ROCBias;
import java.util.Comparator;

public class WeightedConfidenceAndLabel
implements Comparable {
    private final double confidence;
    private final double label;
    private final double prediction;
    private double weight = 1.0;

    public WeightedConfidenceAndLabel(double confidence, double label, double prediction) {
        this(confidence, label, prediction, 1.0);
    }

    public WeightedConfidenceAndLabel(double confidence, double label, double prediction, double weight) {
        this.confidence = confidence;
        this.label = label;
        this.prediction = prediction;
        this.weight = weight;
    }

    public int compareTo(Object obj) {
        int compi = -1 * Double.compare(this.confidence, ((WeightedConfidenceAndLabel)obj).confidence);
        if (compi == 0) {
            return -Double.compare(this.label, ((WeightedConfidenceAndLabel)obj).label);
        }
        return compi;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WeightedConfidenceAndLabel)) {
            return false;
        }
        WeightedConfidenceAndLabel l = (WeightedConfidenceAndLabel)o;
        return this.label == l.label && this.confidence == l.confidence;
    }

    public int hashCode() {
        return Double.valueOf(this.label).hashCode() ^ Double.valueOf(this.confidence).hashCode();
    }

    public double getLabel() {
        return this.label;
    }

    public double getPrediction() {
        return this.prediction;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getWeight() {
        return this.weight;
    }

    public String toString() {
        return "conf: " + this.confidence + ", label: " + this.label + ", weight: " + this.weight;
    }

    public static class WCALComparator
    implements Comparator<WeightedConfidenceAndLabel> {
        private ROCBias method;

        public WCALComparator(ROCBias method) {
            this.method = method;
        }

        @Override
        public int compare(WeightedConfidenceAndLabel o1, WeightedConfidenceAndLabel o2) {
            int compi = -1 * Double.compare(o1.confidence, o2.confidence);
            if (compi == 0) {
                switch (this.method) {
                    case OPTIMISTIC: {
                        return -Double.compare(o1.label, o2.label);
                    }
                }
                return Double.compare(o1.label, o2.label);
            }
            return compi;
        }
    }
}

