/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import java.util.Arrays;

public class VectorMath {
    public static final double[] vectorSubtraction(double[] x, double[] y) {
        if (y == null || x == null) {
            throw new RuntimeException("Cannot substract vectors: one vector is null");
        }
        if (x.length != y.length) {
            throw new RuntimeException("Cannot substract vectors: incompatible numbers of attributes (" + x.length + " != " + y.length + ")!");
        }
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = x[i] - y[i];
        }
        return result;
    }

    public static final double[] vectorAddition(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Cannot add vectors: incompatible numbers of attributes (" + x.length + " != " + y.length + ")!");
        }
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = x[i] + y[i];
        }
        return result;
    }

    public static final double vectorMultiplication(double[] vec1, double[] vec2) {
        if (vec1.length != vec2.length) {
            throw new RuntimeException("Cannot multiply vectors: incompatible numbers of attributes (" + vec1.length + " != " + vec2.length + ")!");
        }
        double resultEven = 0.0;
        double resultOdd = 0.0;
        int until = vec1.length - vec1.length % 2;
        for (int jEven = 0; jEven < until; jEven += 2) {
            int jOdd = jEven + 1;
            resultEven += vec1[jEven] * vec2[jEven];
            resultOdd += vec1[jOdd] * vec2[jOdd];
        }
        if (vec1.length % 2 == 1) {
            return resultEven + resultOdd + vec1[vec1.length - 1] * vec2[vec1.length - 1];
        }
        return resultEven + resultOdd;
    }

    public static final double[] vectorMultiplication(double[] x, double y) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = x[i] * y;
        }
        return result;
    }

    public static final double[] vectorDivision(double[] x, double y) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = x[i] / y;
        }
        return result;
    }

    public static final double[][] matrixDivision(double[][] x, double y) {
        double[][] result = null;
        if (x.length != 0) {
            result = new double[x.length][x[0].length];
            for (int i = 0; i < x.length; ++i) {
                for (int j = 0; j < x[0].length; ++j) {
                    result[i][j] = x[i][j] / y;
                }
            }
        }
        return result;
    }

    public static double[] squareComponents(double[] a) {
        return VectorMath.multiplyComponents(a, a);
    }

    public static double[] multiplyComponents(double[] a, double[] b) {
        double[] prods = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            prods[i] = a[i] * b[i];
        }
        return prods;
    }

    public static double sum(double[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static double[] subtractComponents(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] - b[i];
        }
        return result;
    }

    public static double[] scalarProduct(double[] a, double s) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * s;
        }
        return result;
    }

    public static double[] sumComponents(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public double angle(double[] a, double[] b) {
        return Math.acos(VectorMath.dot(a, b) / (VectorMath.vectorNorm(a) * VectorMath.vectorNorm(b)));
    }

    public double[] bisector(double[] a, double[] b) {
        double[] diff = VectorMath.subtractComponents(a, b);
        double[] sum = VectorMath.sumComponents(a, b);
        double dot = VectorMath.dot(diff, sum);
        double[] result = new double[diff.length + 1];
        System.arraycopy(diff, 0, result, 0, diff.length);
        result[diff.length] = -dot / 2.0;
        return result;
    }

    public static double vectorNorm(double[] a) {
        double quadSum = 0.0;
        for (double comp : a) {
            quadSum += comp * comp;
        }
        return Math.sqrt(quadSum);
    }

    public static double dot(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i];
        }
        return sum;
    }

    public static double[] normalize(double[] array, double lowerBound, double upperBound) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < min) {
                min = array[i];
            }
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        double targetDynamicRange = upperBound - lowerBound;
        double dynamicRange = max - min;
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (array[i] - min) / dynamicRange * targetDynamicRange + lowerBound;
        }
        return result;
    }

    public static final double[] polynomialExpansion(double[] x, int degree) {
        double[] result = new double[VectorMath.getPolynomialExpansionSize(x.length, degree)];
        int current = 0;
        result[current++] = 1.0;
        block0: for (int currentDegree = 1; currentDegree <= degree; ++currentDegree) {
            int[] counter = new int[currentDegree];
            while (true) {
                double currentResult = x[counter[0]];
                for (int currentCounter = 1; currentCounter < currentDegree; ++currentCounter) {
                    currentResult *= x[counter[currentCounter]];
                }
                result[current] = currentResult;
                ++current;
                if (VectorMath.isLastPosition(counter, x.length)) continue block0;
                counter[0] = counter[0] + 1;
                if (counter[0] != x.length) continue;
                counter[0] = VectorMath.moveCounterAhead(counter, 1, x.length);
            }
        }
        return result;
    }

    private static final int moveCounterAhead(int[] counter, int counterPos, int numberOfComponents) {
        int n = counterPos;
        counter[n] = counter[n] + 1;
        if (counter[counterPos] == numberOfComponents) {
            counter[counterPos] = VectorMath.moveCounterAhead(counter, counterPos + 1, numberOfComponents);
        }
        return counter[counterPos];
    }

    private static final boolean isLastPosition(int[] counter, int numberOfElements) {
        for (int i = 0; i < counter.length; ++i) {
            if (counter[i] >= numberOfElements - 1) continue;
            return false;
        }
        return true;
    }

    public static final int getPolynomialExpansionSize(int numberOfComponents, int degree) {
        int[] result = new int[numberOfComponents];
        Arrays.fill(result, 1);
        int totalSum = 1;
        for (int currentDegree = 1; currentDegree <= degree; ++currentDegree) {
            for (int i = 0; i < result.length; ++i) {
                totalSum += result[i];
                int sum = 0;
                for (int j = i; j < result.length; ++j) {
                    sum += result[j];
                }
                result[i] = sum;
            }
        }
        return totalSum;
    }

    public static final double getMedian(double[] residuals) {
        double[] copy = (double[])residuals.clone();
        Arrays.sort(copy);
        return copy[copy.length / 2];
    }

    public static double maximalElement(double[] values) {
        double maximal = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            maximal = values[i] > maximal ? values[i] : maximal;
        }
        return maximal;
    }

    public static double minimalElement(double[] values) {
        double minimal = Double.POSITIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            minimal = values[i] < minimal ? values[i] : minimal;
        }
        return minimal;
    }
}

