/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.operator.OperatorException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringToMatrixConverter {
    private static final String ROW_DELIMITER = ";";
    private static final String VALUE_DELIMITER = " ";

    public static String createMatlabString(double[][] matrix) {
        StringBuffer matrixString = new StringBuffer();
        if (matrix == null) {
            return "";
        }
        matrixString.append("[");
        int numberOfColumns = matrix.length;
        int numberOfRows = matrix[0].length;
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns - 1; ++j) {
                matrixString.append(matrix[i][j] + VALUE_DELIMITER);
            }
            matrixString.append(matrix[i][numberOfColumns - 1] + ROW_DELIMITER);
        }
        matrixString.deleteCharAt(matrixString.length() - 1);
        matrixString.append("]");
        return matrixString.toString();
    }

    public static double[][] parseMatlabString(String matrixString) throws OperatorException {
        int i;
        String[] matrixRows;
        if (matrixString == null || matrixString.trim().length() == 0) {
            return null;
        }
        Pattern possibleRedundantWhitespace = Pattern.compile("\\s+");
        Matcher whitespaceMatcher = possibleRedundantWhitespace.matcher(matrixString);
        matrixString = whitespaceMatcher.replaceAll(VALUE_DELIMITER);
        Pattern lineFeed = Pattern.compile("\\n");
        Matcher lineFeedMatcher = lineFeed.matcher(matrixString);
        matrixString = lineFeedMatcher.replaceAll("");
        matrixString = matrixString.trim();
        Pattern illegalChar = Pattern.compile("[^0-9\\-\\+\\.\\,\\; \\[\\]]");
        Matcher findIllegalChar = illegalChar.matcher(matrixString);
        if (findIllegalChar.find()) {
            throw new OperatorException("StringToMatrixConverter: Matlab String contains illegal characters, parsing failed.");
        }
        Pattern squareBrackets = Pattern.compile("[\\[\\]]");
        Matcher removeSquareBrackets = squareBrackets.matcher(matrixString);
        matrixString = removeSquareBrackets.replaceAll("");
        String usedDelimiter = VALUE_DELIMITER;
        if (matrixString.indexOf(",") < 0) {
            usedDelimiter = VALUE_DELIMITER;
            matrixString = matrixString.trim();
        } else {
            Pattern space = Pattern.compile("\\s+");
            Matcher spaceMatcher = space.matcher(matrixString);
            matrixString = spaceMatcher.replaceAll("");
        }
        try {
            matrixRows = matrixString.split(ROW_DELIMITER);
        }
        catch (Exception e) {
            throw new OperatorException("StringToMatrixConverter: Matlab String does not provide correct row separation, parsing failed.");
        }
        int numberOfRows = matrixRows.length;
        int numberOfValues = matrixRows[0].split(usedDelimiter).length;
        String[][] stringMatrix = new String[numberOfRows][];
        try {
            for (i = 0; i < numberOfRows; ++i) {
                matrixRows[i] = matrixRows[i].trim();
                String[] currentRow = matrixRows[i].split(usedDelimiter);
                if (currentRow.length != numberOfValues) {
                    throw new OperatorException("StringToMatrixConverter: Matlab String contains data rows of different length, parsing failed.");
                }
                stringMatrix[i] = currentRow;
            }
        }
        catch (Exception e) {
            if (e instanceof OperatorException) {
                throw (OperatorException)e;
            }
            throw new OperatorException("StringToMatrixConverter: Matlab String does not provide correct value separation, parsing failed.");
        }
        double[][] matrix = new double[numberOfRows][numberOfValues];
        try {
            for (i = 0; i < numberOfRows; ++i) {
                for (int j = 0; j < numberOfValues; ++j) {
                    matrix[i][j] = Double.parseDouble(stringMatrix[i][j]);
                }
            }
        }
        catch (RuntimeException e) {
            throw new OperatorException("StringToMatrixConverter: Matlab String contains irregular values, all values must be integer or double literals. Parsing failed.");
        }
        return matrix;
    }
}

