/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import com.rapidminer.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.Iterator;

public class RunVector
extends ResultObjectAdapter {
    private static final long serialVersionUID = -5481280692066966385L;
    private ArrayList<AverageVector> vectorList = new ArrayList();

    public void addVector(AverageVector av) {
        this.vectorList.add(av);
    }

    public AverageVector getVector(int index) {
        return this.vectorList.get(index);
    }

    public ArrayList getVectorList() {
        return this.vectorList;
    }

    public int size() {
        return this.vectorList.size();
    }

    public AverageVector average() {
        try {
            AverageVector output = (AverageVector)this.getVector(0).clone();
            for (int i = 1; i < this.size(); ++i) {
                AverageVector av = this.getVector(i);
                for (int j = 0; j < av.size(); ++j) {
                    output.getAveragable(j).buildAverage(av.getAveragable(j));
                }
            }
            return output;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone of average vector is not supported: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("RunVector:" + Tools.getLineSeparator());
        Iterator<AverageVector> i = this.vectorList.iterator();
        while (i.hasNext()) {
            result.append(i.next() + Tools.getLineSeparator());
        }
        return result.toString();
    }

    @Override
    public String toResultString() {
        StringBuffer result = new StringBuffer("");
        AverageVector averageVector = this.average();
        for (int averagableIndex = 0; averagableIndex < averageVector.size(); ++averagableIndex) {
            result.append("Time series of averagable '" + this.getVector(0).getAveragable(averagableIndex).getName() + "':");
            for (int timeIndex = 0; timeIndex < this.size(); ++timeIndex) {
                AverageVector currentAveragables = this.getVector(timeIndex);
                Averagable averagable = currentAveragables.getAveragable(averagableIndex);
                result.append("  " + averagable.getAverage());
            }
            result.append(Tools.getLineSeparator());
        }
        for (int i = 0; i < averageVector.size(); ++i) {
            Averagable averagable = averageVector.getAveragable(i);
            result.append("  Average of averagable '" + averagable.getName() + "':  " + averagable.getAverage());
            if (averagable.getVariance() >= 0.0) {
                result.append("  (" + averagable.getVariance() + ")");
            }
            result.append(Tools.getLineSeparator());
        }
        result.append(Tools.getLineSeparator());
        return result.toString();
    }

    public String getExtension() {
        return "rvc";
    }

    public String getFileDescription() {
        return "run vector";
    }
}

