/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.ROCPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ROCData
implements Iterable<ROCPoint>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ROCPoint> points = new ArrayList<ROCPoint>();
    private double sumPos;
    private double sumNeg;
    private double bestIsometricsTP;

    public void addPoint(ROCPoint point) {
        this.points.add(point);
    }

    public void removePoint(ROCPoint point) {
        this.points.remove(point);
    }

    public int getNumberOfPoints() {
        return this.points.size();
    }

    public ROCPoint getPoint(int index) {
        return this.points.get(index);
    }

    public double getInterpolatedTruePositives(double d) {
        if (Tools.isZero(d)) {
            return 0.0;
        }
        if (Tools.isGreaterEqual(d, this.getTotalPositives())) {
            return this.getTotalPositives();
        }
        ROCPoint last = null;
        double lastFpDivN = 0.0;
        for (ROCPoint p : this) {
            double fpDivN = p.getFalsePositives() / this.getTotalNegatives();
            if (Tools.isGreater(fpDivN, d)) {
                if (last == null) {
                    return 0.0;
                }
                double alpha = (d - lastFpDivN) / (fpDivN - lastFpDivN);
                return last.getTruePositives() + alpha * (p.getTruePositives() - last.getTruePositives());
            }
            last = p;
            lastFpDivN = fpDivN;
        }
        return this.getTotalPositives();
    }

    public double getInterpolatedThreshold(double d) {
        if (Tools.isZero(d)) {
            return 1.0;
        }
        if (Tools.isGreaterEqual(d, this.getTotalPositives())) {
            return 0.0;
        }
        ROCPoint last = null;
        for (ROCPoint p : this) {
            double fpDivN = p.getFalsePositives() / this.getTotalNegatives();
            if (Tools.isGreater(fpDivN, d)) {
                if (last == null) {
                    return 1.0;
                }
                return last.getConfidence();
            }
            last = p;
        }
        if (last == null) {
            return 0.0;
        }
        return last.getConfidence();
    }

    @Override
    public Iterator<ROCPoint> iterator() {
        return this.points.iterator();
    }

    public void setTotalPositives(double sumPos) {
        this.sumPos = sumPos;
    }

    public double getTotalPositives() {
        return this.sumPos;
    }

    public void setTotalNegatives(double sumNeg) {
        this.sumNeg = sumNeg;
    }

    public double getTotalNegatives() {
        return this.sumNeg;
    }

    public void setBestIsometricsTPValue(double value) {
        this.bestIsometricsTP = value;
    }

    public double getBestIsometricsTPValue() {
        return this.bestIsometricsTP;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("ROC Points" + Tools.getLineSeparator());
        for (ROCPoint p : this.points) {
            result.append(p + Tools.getLineSeparator());
        }
        return result.toString();
    }
}

