/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import Jama.Matrix;
import com.rapidminer.Process;
import java.util.logging.Logger;

public class LinearRegression {
    private static Logger logger = Logger.getLogger(Process.class.getName());

    public static double[] performRegression(Matrix x, Matrix y, double[] weights, double ridge) {
        Matrix weightedIndependent = new Matrix(x.getRowDimension(), x.getColumnDimension());
        Matrix weightedDependent = new Matrix(x.getRowDimension(), 1);
        for (int i = 0; i < weights.length; ++i) {
            double sqrtWeight = Math.sqrt(weights[i]);
            for (int j = 0; j < x.getColumnDimension(); ++j) {
                weightedIndependent.set(i, j, x.get(i, j) * sqrtWeight);
            }
            weightedDependent.set(i, 0, y.get(i, 0) * sqrtWeight);
        }
        return LinearRegression.performRegression(weightedIndependent, weightedDependent, ridge);
    }

    public static double[] performRegression(Matrix x, Matrix y, double ridge) {
        int numberOfColumns = x.getColumnDimension();
        double[] coefficients = new double[numberOfColumns];
        Matrix xTransposed = x.transpose();
        boolean finished = false;
        while (!finished) {
            int i;
            Matrix xTx = xTransposed.times(x);
            for (int i2 = 0; i2 < numberOfColumns; ++i2) {
                xTx.set(i2, i2, xTx.get(i2, i2) + ridge);
            }
            Matrix xTy = xTransposed.times(y);
            for (i = 0; i < numberOfColumns; ++i) {
                coefficients[i] = xTy.get(i, 0);
            }
            try {
                Matrix result = xTx.solve(new Matrix(coefficients, coefficients.length));
                for (i = 0; i < numberOfColumns; ++i) {
                    coefficients[i] = result.get(i, 0);
                }
                finished = true;
            }
            catch (Exception ex) {
                double ridgeOld = ridge;
                ridge = ridge > 0.0 ? (ridge *= 10.0) : 1.0E-7;
                finished = false;
                logger.warning("Error during calculation: " + ex.getMessage() + ": Increasing ridge factor from " + ridgeOld + " to " + ridge);
            }
        }
        return coefficients;
    }
}

