/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.Complex;
import com.rapidminer.tools.math.WindowFunction;
import java.util.ArrayList;
import java.util.Collections;

public class FastFourierTransform {
    public static final int TIME2FREQUENCY = 0;
    public static final int FREQUENCY2TIME = 1;
    private int windowFunctionType = 1;

    public FastFourierTransform(int windowFunctionType) {
        this.windowFunctionType = windowFunctionType;
    }

    public Complex[] getFourierTransform(ExampleSet exampleSet, Attribute source, Attribute target) throws OperatorException {
        ArrayList<Tupel<Double, Double>> values = new ArrayList<Tupel<Double, Double>>();
        for (Example example : exampleSet) {
            Tupel<Double, Double> tupel = new Tupel<Double, Double>(example.getValue(target), example.getValue(source));
            values.add(tupel);
        }
        Collections.sort(values);
        Complex[] complex = new Complex[exampleSet.size()];
        int k = 0;
        for (Tupel tupel : values) {
            complex[k++] = new Complex((Double)tupel.getSecond(), 0.0);
        }
        return this.getFourierTransform(complex, 0, this.windowFunctionType);
    }

    public static double convertFrequency(double frequency, int nyquist, int totalLength) {
        return frequency / (Math.PI * 2) * ((double)totalLength / (double)nyquist);
    }

    public Complex[] getFourierTransform(Complex[] series, int direction, int functionType) throws OperatorException {
        double ti;
        double tr;
        int n = FastFourierTransform.getGreatestPowerOf2LessThan(series.length);
        WindowFunction filter = new WindowFunction(functionType, n);
        if (n < 2) {
            throw new UserError(null, 110, "4");
        }
        int nu = (int)(Math.log(n) / Math.log(2.0));
        int n2 = n / 2;
        int nu1 = nu - 1;
        double[] xre = new double[n];
        double[] xim = new double[n];
        for (int i = 0; i < n; ++i) {
            xre[i] = filter.getFactor(i) * series[i].getReal();
            xim[i] = filter.getFactor(i) * series[i].getImaginary();
        }
        int k = 0;
        for (int l = 1; l <= nu; ++l) {
            while (k < n) {
                for (int i = 1; i <= n2; ++i) {
                    double p = this.bitrev(k >> nu1, nu);
                    double arg = Math.PI * 2 * p / (double)n;
                    double c = Math.cos(arg);
                    double s = Math.sin(arg);
                    tr = xre[k + n2] * c + xim[k + n2] * s;
                    ti = xim[k + n2] * c - xre[k + n2] * s;
                    xre[k + n2] = xre[k] - tr;
                    xim[k + n2] = xim[k] - ti;
                    int n3 = k;
                    xre[n3] = xre[n3] + tr;
                    int n4 = k++;
                    xim[n4] = xim[n4] + ti;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 /= 2;
        }
        for (k = 0; k < n; ++k) {
            int r = this.bitrev(k, nu);
            if (r <= k) continue;
            tr = xre[k];
            ti = xim[k];
            xre[k] = xre[r];
            xim[k] = xim[r];
            xre[r] = tr;
            xim[r] = ti;
        }
        int nyquist = n / 2;
        Complex[] result = new Complex[nyquist];
        switch (direction) {
            case 0: {
                for (int i = 0; i < nyquist; ++i) {
                    result[i] = new Complex(-xre[i], xim[i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < nyquist; ++i) {
                    result[i] = new Complex(-xre[i], xim[i]);
                }
                break;
            }
        }
        return result;
    }

    public static int getGreatestPowerOf2LessThan(int n) {
        int power = (int)(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, power);
    }

    private int bitrev(int j, double nu) {
        int j1 = j;
        int k = 0;
        int i = 1;
        while ((double)i <= nu) {
            int j2 = j1 / 2;
            k = 2 * k + j1 - 2 * j2;
            j1 = j2;
            ++i;
        }
        return k;
    }
}

