/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

public class FDistribution {
    private static final double[] GAMMA_COEFFICIENTS = new double[]{76.18009172947146, -86.50532032941678, 25.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private int degreeOfFreedom1 = 0;
    private int degreeOfFreedom2 = 0;

    public FDistribution(int degreeOfFreedom1, int degreeOfFreedom2) {
        this.degreeOfFreedom1 = degreeOfFreedom1;
        this.degreeOfFreedom2 = degreeOfFreedom2;
    }

    public double getProbabilityForValue(double value) {
        return this.betaInverse((double)this.degreeOfFreedom1 * value / ((double)this.degreeOfFreedom1 * value + (double)this.degreeOfFreedom2), 0.5 * (double)this.degreeOfFreedom1, 0.5 * (double)this.degreeOfFreedom2);
    }

    private double lnGamma(double c) {
        double xx = c;
        double yy = c;
        double tmp = xx + 5.5 - (xx + 0.5) * Math.log(xx + 5.5);
        double ser = 1.000000000190015;
        for (int i = 0; i < GAMMA_COEFFICIENTS.length; ++i) {
            ser += GAMMA_COEFFICIENTS[i] / (yy += 1.0);
        }
        return Math.log(2.5066282746310007 * ser / xx) - tmp;
    }

    private double lnBeta(double a, double b) {
        return this.lnGamma(a) + this.lnGamma(b) - this.lnGamma(a + b);
    }

    private double betaInverse(double x1, double p, double q) {
        boolean index;
        double beta = this.lnBeta(p, q);
        double acu = 1.0E-14;
        if (p <= 0.0 || q <= 0.0) {
            return -1.0;
        }
        if (x1 <= 0.0 || x1 >= 1.0) {
            return -1.0;
        }
        double psq = p + q;
        double cx = 1.0 - x1;
        double x2 = Double.NaN;
        double pp = Double.NaN;
        double qq = Double.NaN;
        if (p < psq * x1) {
            x2 = cx;
            cx = x1;
            pp = q;
            qq = p;
            index = true;
        } else {
            x2 = x1;
            pp = p;
            qq = q;
            index = false;
        }
        double term = 1.0;
        int ai = 1;
        double betain = 1.0;
        double ns = qq + cx * psq;
        double rx = x2 / cx;
        double temp = qq - (double)ai;
        if (ns == 0.0) {
            rx = x2;
        }
        while (temp > acu && temp > acu * betain) {
            term = term * temp * rx / (pp + (double)ai);
            betain += term;
            temp = Math.abs(term);
            if (!(temp > acu) || !(temp > acu * betain)) continue;
            ++ai;
            if ((ns -= 1.0) >= 0.0) {
                temp = qq - (double)ai;
                if (ns != 0.0) continue;
                rx = x2;
                continue;
            }
            temp = psq;
            psq += 1.0;
        }
        betain *= Math.exp(pp * Math.log(x2) + (qq - 1.0) * Math.log(cx) - beta) / pp;
        if (index) {
            betain = 1.0 - betain;
        }
        return betain;
    }
}

