/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.tools.Tools;

public class ContingencyTableTools {
    public static double getChiSquaredStatistics(double[][] matrix, boolean useYatesCorrection) {
        int numberOfRows = matrix.length;
        int numberOfColumns = matrix[0].length;
        double[] rowSums = new double[numberOfRows];
        double[] columnSums = new double[numberOfColumns];
        double totalSum = 0.0;
        for (int row = 0; row < numberOfRows; ++row) {
            for (int column = 0; column < numberOfColumns; ++column) {
                int n = row;
                rowSums[n] = rowSums[n] + matrix[row][column];
                int n2 = column;
                columnSums[n2] = columnSums[n2] + matrix[row][column];
                totalSum += matrix[row][column];
            }
        }
        int degreesOfFreedom = (numberOfRows - 1) * (numberOfColumns - 1);
        boolean useYates = true;
        if (degreesOfFreedom > 1 || !useYatesCorrection) {
            useYates = false;
        } else if (degreesOfFreedom <= 0) {
            return 0.0;
        }
        double expectedValue = 0.0;
        double chiSquaredValue = 0.0;
        for (int row = 0; row < numberOfRows; ++row) {
            if (!(rowSums[row] > 0.0)) continue;
            for (int column = 0; column < numberOfColumns; ++column) {
                if (!(columnSums[column] > 0.0)) continue;
                expectedValue = columnSums[column] * rowSums[row] / totalSum;
                chiSquaredValue += ContingencyTableTools.getChiSquaredForEntry(matrix[row][column], expectedValue, useYates);
            }
        }
        return chiSquaredValue;
    }

    private static double getChiSquaredForEntry(double actualFrequency, double expectedFrequency, boolean useYatesCorrection) {
        if (expectedFrequency <= 0.0) {
            return 0.0;
        }
        double difference = Math.abs(actualFrequency - expectedFrequency);
        if (useYatesCorrection && (difference -= 0.5) < 0.0) {
            difference = 0.0;
        }
        return difference * difference / expectedFrequency;
    }

    public static double[][] deleteEmpty(double[][] matrix) {
        int numberOfRows = matrix.length;
        int numberOfColumns = matrix[0].length;
        double[] rowSums = new double[numberOfRows];
        double[] columnSums = new double[numberOfColumns];
        for (int row = 0; row < numberOfRows; ++row) {
            for (int column = 0; column < numberOfColumns; ++column) {
                int n = row;
                rowSums[n] = rowSums[n] + matrix[row][column];
                int n2 = column;
                columnSums[n2] = columnSums[n2] + matrix[row][column];
            }
        }
        int nonZeroRowCounter = 0;
        for (int row = 0; row < numberOfRows; ++row) {
            if (!(rowSums[row] > 0.0)) continue;
            ++nonZeroRowCounter;
        }
        int nonZeroColumnCounter = 0;
        for (int column = 0; column < numberOfColumns; ++column) {
            if (!(columnSums[column] > 0.0)) continue;
            ++nonZeroColumnCounter;
        }
        double[][] result = new double[nonZeroRowCounter][nonZeroColumnCounter];
        int rowIndex = 0;
        for (int row = 0; row < numberOfRows; ++row) {
            if (!(rowSums[row] > 0.0)) continue;
            int columnIndex = 0;
            for (int column = 0; column < numberOfColumns; ++column) {
                if (!(columnSums[column] > 0.0)) continue;
                result[rowIndex][columnIndex] = matrix[row][column];
                ++columnIndex;
            }
            ++rowIndex;
        }
        return result;
    }

    public static double symmetricalUncertainty(double[][] matrix) {
        double columnSum = 0.0;
        double columnEntropy = 0.0;
        double totalSum = 0.0;
        for (int i = 0; i < matrix[0].length; ++i) {
            columnSum = 0.0;
            for (int j = 0; j < matrix.length; ++j) {
                columnSum += matrix[j][i];
            }
            columnEntropy += ContingencyTableTools.entropy(columnSum);
            totalSum += columnSum;
        }
        columnEntropy -= ContingencyTableTools.entropy(totalSum);
        double rowSum = 0.0;
        double rowEntropy = 0.0;
        double entropyForRows = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            rowSum = 0.0;
            for (int j = 0; j < matrix[0].length; ++j) {
                rowSum += matrix[i][j];
                entropyForRows += ContingencyTableTools.entropy(matrix[i][j]);
            }
            rowEntropy += ContingencyTableTools.entropy(rowSum);
        }
        entropyForRows -= rowEntropy;
        double informationGain = columnEntropy - entropyForRows;
        if (Tools.isEqual(columnEntropy, 0.0) || Tools.isEqual(rowEntropy -= ContingencyTableTools.entropy(totalSum), 0.0)) {
            return 0.0;
        }
        return 2.0 * (informationGain / (columnEntropy + rowEntropy));
    }

    private static double entropy(double value) {
        if (Tools.isZero(value)) {
            return 0.0;
        }
        return value * Math.log(value);
    }
}

