/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AverageVector
extends ResultObjectAdapter
implements Comparable,
Cloneable {
    private static final long serialVersionUID = 6207859713603581755L;
    private List<Averagable> averagesList = new ArrayList<Averagable>();

    public abstract Object clone() throws CloneNotSupportedException;

    public boolean equals(Object o) {
        if (!(o instanceof AverageVector)) {
            return false;
        }
        AverageVector v = (AverageVector)o;
        return ((Object)this.averagesList).equals(v.averagesList);
    }

    public int hashCode() {
        return ((Object)this.averagesList).hashCode();
    }

    public int size() {
        return this.averagesList.size();
    }

    public void addAveragable(Averagable avg) {
        this.averagesList.add(avg);
    }

    public void removeAveragable(Averagable avg) {
        this.averagesList.remove(avg);
    }

    public Averagable getAveragable(int index) {
        return this.averagesList.get(index);
    }

    public Averagable getAveragable(String name) {
        for (Averagable a : this.averagesList) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public int getSize() {
        return this.averagesList.size();
    }

    @Override
    public String toResultString() {
        StringBuffer result = new StringBuffer(this.getName());
        result.append(":");
        result.append(Tools.getLineSeparator());
        Iterator<Averagable> i = this.averagesList.iterator();
        while (i.hasNext()) {
            result.append(i.next().toResultString());
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("AverageVector [");
        for (int i = 0; i < this.size(); ++i) {
            Averagable avg = this.getAveragable(i);
            if (i > 0) {
                result.append(", ");
            }
            result.append(avg);
        }
        result.append("]");
        return result.toString();
    }

    public void buildAverages(AverageVector av) {
        if (this.size() != av.size()) {
            throw new IllegalArgumentException("Performance vectors have different size!");
        }
        for (int i = 0; i < this.size(); ++i) {
            this.getAveragable(i).buildAverage(av.getAveragable(i));
        }
    }
}

