/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.report.Readable;
import com.rapidminer.tools.Tools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class Averagable
extends ResultObjectAdapter
implements Cloneable,
Readable {
    private static final long serialVersionUID = 3193522429555690641L;
    private double meanSum;
    private double meanSquaredSum;
    private int averageCount;

    public Averagable() {
        this.meanSum = Double.NaN;
        this.meanSquaredSum = Double.NaN;
        this.averageCount = 0;
    }

    public Averagable(Averagable o) {
        this.meanSum = o.meanSum;
        this.meanSquaredSum = o.meanSquaredSum;
        this.averageCount = o.averageCount;
    }

    @Override
    public abstract String getName();

    public abstract double getMikroAverage();

    public abstract double getMikroVariance();

    @Deprecated
    protected final void cloneAveragable(Averagable other) {
    }

    protected abstract void buildSingleAverage(Averagable var1);

    public final void buildAverage(Averagable averagable) {
        double value;
        if (!averagable.getClass().equals(this.getClass())) {
            throw new RuntimeException("Cannot build average of different averagable types (" + this.getClass().getName() + "/" + averagable.getClass().getName() + ").");
        }
        if (!averagable.getName().equals(this.getName())) {
            throw new RuntimeException("Cannot build average of different averagable types (" + this.getName() + "/" + averagable.getName() + ").");
        }
        if (this.averageCount == 0) {
            this.meanSum = value = this.getMikroAverage();
            this.meanSquaredSum = value * value;
            this.averageCount = 1;
        }
        value = averagable.getMikroAverage();
        this.meanSum += value;
        this.meanSquaredSum += value * value;
        ++this.averageCount;
        this.buildSingleAverage(averagable);
    }

    public final double getAverage() {
        double average = Double.NaN;
        if (this.averageCount > 0) {
            average = this.getMakroAverage();
        }
        if (Double.isNaN(average)) {
            average = this.getMikroAverage();
        }
        return average;
    }

    public final double getVariance() {
        double variance = Double.NaN;
        if (this.averageCount > 0) {
            variance = this.getMakroVariance();
        }
        if (Double.isNaN(variance)) {
            variance = this.getMikroVariance();
        }
        return variance;
    }

    public final double getStandardDeviation() {
        double sd = Double.NaN;
        if (this.averageCount > 0) {
            sd = this.getMakroStandardDeviation();
        }
        if (Double.isNaN(sd)) {
            sd = this.getMikroStandardDeviation();
        }
        return sd;
    }

    public final double getMikroStandardDeviation() {
        double variance = this.getMikroVariance();
        if (Double.isNaN(variance)) {
            return Double.NaN;
        }
        if (variance < 0.0) {
            return 0.0;
        }
        return Math.sqrt(variance);
    }

    public final double getMakroAverage() {
        return this.meanSum / (double)this.averageCount;
    }

    public final double getMakroVariance() {
        double mean = this.getMakroAverage();
        double result = this.meanSquaredSum / (double)this.averageCount - mean * mean;
        if (Double.isNaN(result)) {
            return Double.NaN;
        }
        if (result < 0.0) {
            return 0.0;
        }
        return result;
    }

    public final double getMakroStandardDeviation() {
        return Math.sqrt(this.getMakroVariance());
    }

    public int getAverageCount() {
        return this.averageCount;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> cloneConstructor = clazz.getConstructor(clazz);
            Averagable result = (Averagable)cloneConstructor.newInstance(this);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException("Cannot clone averagable: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new CloneNotSupportedException("Cannot clone averagable: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new CloneNotSupportedException("Cannot clone averagable: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new CloneNotSupportedException("Cannot clone averagable: " + e.getMessage());
        }
    }

    public boolean formatPercent() {
        return false;
    }

    private final String formatValue(double value) {
        if (Double.isNaN(value)) {
            return "unknown";
        }
        if (this.formatPercent()) {
            return Tools.formatPercent(value);
        }
        return Tools.formatNumber(value);
    }

    private final String formatDeviation(double dev) {
        if (this.formatPercent()) {
            return Tools.formatPercent(dev);
        }
        return Tools.formatNumber(dev);
    }

    public String getExtension() {
        return "avg";
    }

    public String getFileDescription() {
        return "averagable";
    }

    @Override
    public String toString() {
        double makroAverage;
        StringBuffer result = new StringBuffer(this.getName() + ": ");
        boolean makroUsable = false;
        if (this.averageCount > 0 && !Double.isNaN(makroAverage = this.getMakroAverage())) {
            makroUsable = true;
            result.append(this.formatValue(makroAverage));
            double sd = this.getMakroStandardDeviation();
            if (!Double.isNaN(sd)) {
                result.append(" +/- " + this.formatDeviation(sd));
            }
        }
        if (makroUsable) {
            result.append(" (mikro: ");
        }
        result.append(this.formatValue(this.getMikroAverage()));
        double sd = this.getMikroStandardDeviation();
        if (!Double.isNaN(sd)) {
            result.append(" +/- " + this.formatDeviation(sd));
        }
        if (makroUsable) {
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public boolean isInTargetEncoding() {
        return false;
    }

    public void setAverageCount(int averageCount) {
        this.averageCount = averageCount;
    }
}

