/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.FDistribution;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import com.rapidminer.tools.math.TestGroup;
import java.util.LinkedList;
import java.util.List;

public class AnovaCalculator {
    private double alpha = 0.05;
    private List<TestGroup> groups = new LinkedList<TestGroup>();

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void addGroup(TestGroup group) {
        this.groups.add(group);
    }

    public void addGroup(double numberOfValues, double mean, double variance) {
        this.addGroup(new TestGroup(numberOfValues, mean, variance));
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public SignificanceTestResult performSignificanceTest() throws SignificanceCalculationException {
        if (this.groups.size() < 2) {
            throw new SignificanceCalculationException("Cannot calculate ANOVA: not enough groups added (current number of groups: " + this.groups.size() + ", must be at least 2");
        }
        double meanOfMeans = 0.0;
        for (TestGroup group : this.groups) {
            meanOfMeans += group.getMean();
        }
        meanOfMeans /= (double)this.groups.size();
        double sumSquaresBetween = 0.0;
        for (TestGroup group : this.groups) {
            double diff = group.getMean() - meanOfMeans;
            sumSquaresBetween += group.getNumber() * (diff * diff);
        }
        double sumSquaresResiduals = 0.0;
        int counterSum = 0;
        for (TestGroup group : this.groups) {
            sumSquaresResiduals += (group.getNumber() - 1.0) * group.getVariance();
            counterSum = (int)((double)counterSum + group.getNumber());
        }
        return new AnovaSignificanceTestResult(sumSquaresBetween, sumSquaresResiduals, this.groups.size() - 1, counterSum - this.groups.size(), this.alpha);
    }

    public static class AnovaSignificanceTestResult
    extends SignificanceTestResult {
        private static final long serialVersionUID = 9007616378489018565L;
        private double sumSquaresBetween = 0.0;
        private double sumSquaresResiduals = 0.0;
        private double meanSquaresBetween = 0.0;
        private double meanSquaresResiduals = 0.0;
        private int df1 = 0;
        private int df2 = 0;
        private double alpha = 0.05;
        private double fValue = 0.0;
        private double prob = 0.0;

        public AnovaSignificanceTestResult(double sumSquaresBetween, double sumSquaresResiduals, int df1, int df2, double alpha) {
            this.sumSquaresBetween = sumSquaresBetween;
            this.sumSquaresResiduals = sumSquaresResiduals;
            this.df1 = df1;
            this.df2 = df2;
            this.alpha = alpha;
            this.meanSquaresBetween = sumSquaresBetween / (double)df1;
            this.meanSquaresResiduals = sumSquaresResiduals / (double)df2;
            this.fValue = this.meanSquaresBetween / this.meanSquaresResiduals;
            FDistribution fDist = new FDistribution(df1, df2);
            this.prob = fDist.getProbabilityForValue(this.fValue);
            this.prob = this.prob < 0.0 ? 1.0 : 1.0 - this.prob;
        }

        @Override
        public String getName() {
            return "Anova Test";
        }

        @Override
        public String toString() {
            return "ANOVA result (f=" + Tools.formatNumber(this.fValue) + ", prob=" + Tools.formatNumber(this.prob) + ", alpha=" + Tools.formatNumber(this.alpha) + ")";
        }

        @Override
        public double getProbability() {
            return this.prob;
        }

        public double getSumSquaresBetween() {
            return this.sumSquaresBetween;
        }

        public double getSumSquaresResiduals() {
            return this.sumSquaresResiduals;
        }

        public double getMeanSquaresBetween() {
            return this.meanSquaresBetween;
        }

        public double getMeanSquaresResiduals() {
            return this.meanSquaresResiduals;
        }

        public int getDf1() {
            return this.df1;
        }

        public int getDf2() {
            return this.df2;
        }

        public double getAlpha() {
            return this.alpha;
        }

        public double getFValue() {
            return this.fValue;
        }
    }
}

