/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc.connection;

import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.cipher.CipherException;
import com.rapidminer.tools.cipher.CipherTools;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.JDBCProperties;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import java.security.Key;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FieldConnectionEntry
extends ConnectionEntry {
    static final String XML_TAG_NAME = "field-entry";
    private String host;
    private String port;
    private String database;
    private boolean dynamic = false;

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public FieldConnectionEntry() {
    }

    public FieldConnectionEntry(String name, JDBCProperties properties, String host, String port, String database, String user, char[] password) {
        super(name, properties);
        this.host = host;
        this.port = port;
        this.database = database;
        this.user = user;
        this.password = password;
    }

    @Override
    public String getURL() {
        return FieldConnectionEntry.createURL(this.properties, this.host, this.port, this.database);
    }

    public static String createURL(JDBCProperties properties, String host, String port, String database) {
        StringBuffer urlBuffer = new StringBuffer();
        if (properties != null) {
            urlBuffer.append(properties.getUrlPrefix());
        } else {
            urlBuffer.append("unkown:prefix://");
        }
        if (host != null && !"".equals(host)) {
            urlBuffer.append(host);
            if (port != null && !"".equals(port)) {
                urlBuffer.append(":" + port);
            }
            if (database != null && !"".equals(database)) {
                if (properties != null) {
                    urlBuffer.append(properties.getDbNameSeperator());
                } else {
                    urlBuffer.append("/");
                }
                urlBuffer.append(database);
            }
        }
        return urlBuffer.toString();
    }

    public String getHost() {
        return this.host;
    }

    public boolean equals(Object object) {
        if (object instanceof FieldConnectionEntry) {
            FieldConnectionEntry entry = (FieldConnectionEntry)object;
            boolean equals = true;
            equals &= this.name.equals(entry.name);
            equals &= this.host.equals(entry.host);
            equals &= this.port.equals(entry.port);
            equals &= this.database.equals(entry.database);
            equals &= this.user.equals(entry.user);
            if (equals &= this.password.length == entry.password.length) {
                for (int i = 0; i < this.password.length; ++i) {
                    equals &= this.password[i] == entry.password[i];
                }
            }
            return equals;
        }
        return false;
    }

    public Element toXML(Document doc, Key key, String replacementForLocalhost) throws CipherException {
        Element element = doc.createElement(XML_TAG_NAME);
        XMLTools.setTagContents(element, "name", this.name);
        if (this.properties != null) {
            XMLTools.setTagContents(element, "system", this.properties.getName());
        }
        String host = this.host;
        if (replacementForLocalhost != null) {
            host = host.replace("localhost", replacementForLocalhost);
        }
        XMLTools.setTagContents(element, "host", host);
        XMLTools.setTagContents(element, "port", this.port);
        XMLTools.setTagContents(element, "database", this.database);
        XMLTools.setTagContents(element, "user", this.user);
        XMLTools.setTagContents(element, "password", CipherTools.encrypt(new String(this.password), key));
        return element;
    }

    public FieldConnectionEntry(Element element, Key key) throws CipherException {
        this.name = XMLTools.getTagContents(element, "name");
        this.host = XMLTools.getTagContents(element, "host");
        this.port = XMLTools.getTagContents(element, "port");
        this.database = XMLTools.getTagContents(element, "database");
        this.user = XMLTools.getTagContents(element, "user");
        this.password = CipherTools.decrypt(XMLTools.getTagContents(element, "password"), key).toCharArray();
        String system = XMLTools.getTagContents(element, "system");
        if (system != null) {
            this.properties = DatabaseService.getJDBCProperties(system);
        }
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }
}

