/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc.connection;

import com.rapidminer.io.Base64;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.cipher.CipherException;
import com.rapidminer.tools.cipher.CipherTools;
import com.rapidminer.tools.cipher.KeyGeneratorTool;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.FieldConnectionEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Key;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseConnectionService {
    public static final String PROPERTY_CONNECTIONS_FILE = "connections";
    private static List<FieldConnectionEntry> connections = new LinkedList<FieldConnectionEntry>();
    private static DatabaseHandler handler = null;

    public static void init() {
        File connectionsFile = DatabaseConnectionService.getConnectionsFile();
        if (!connectionsFile.exists()) {
            try {
                connectionsFile.createNewFile();
            }
            catch (IOException iOException) {}
        } else {
            connections = DatabaseConnectionService.readConnectionEntries(connectionsFile);
        }
    }

    private static File getConnectionsFile() {
        return ParameterService.getUserConfigFile(PROPERTY_CONNECTIONS_FILE);
    }

    public static Collection<FieldConnectionEntry> getConnectionEntries() {
        return connections;
    }

    public static ConnectionEntry getConnectionEntry(String name) {
        for (FieldConnectionEntry entry : connections) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static void addConnectionEntry(FieldConnectionEntry entry) {
        connections.add(entry);
        Collections.sort(connections, ConnectionEntry.COMPARATOR);
        DatabaseConnectionService.writeConnectionEntries(connections);
    }

    public static void deleteConnectionEntry(ConnectionEntry entry) {
        connections.remove(entry);
        if (entry != null) {
            DatabaseConnectionService.writeConnectionEntries(connections);
        }
    }

    public static void setConnectionEntries(List<FieldConnectionEntry> entries) {
        connections = entries;
        Collections.sort(connections, ConnectionEntry.COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldConnectionEntry> readConnectionEntries(File connectionEntriesFile) {
        LinkedList<FieldConnectionEntry> connectionEntries = new LinkedList<FieldConnectionEntry>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(connectionEntriesFile));
            String line = in.readLine();
            if (line != null) {
                int numberOfEntries = Integer.parseInt(line);
                for (int i = 0; i < numberOfEntries; ++i) {
                    String name = in.readLine();
                    String system = in.readLine();
                    String host = in.readLine();
                    String port = in.readLine();
                    String database = in.readLine();
                    String user = in.readLine();
                    String password = CipherTools.decrypt(in.readLine());
                    if (name == null || system == null) continue;
                    connectionEntries.add(new FieldConnectionEntry(name, DatabaseService.getJDBCProperties(system), host, port, database, user, password.toCharArray()));
                }
            }
            in.close();
            Collections.sort(connectionEntries, ConnectionEntry.COMPARATOR);
        }
        catch (Exception e) {
            connectionEntries.clear();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return connectionEntries;
    }

    public static void writeConnectionEntries(Collection<FieldConnectionEntry> connectionEntries) {
        File connectionEntriesFile = DatabaseConnectionService.getConnectionsFile();
        try {
            PrintWriter out = new PrintWriter(new FileWriter(connectionEntriesFile));
            DatabaseConnectionService.writeConnectionEntries(connectionEntries, out);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to write database connections file: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConnectionEntries(Collection<FieldConnectionEntry> connectionEntries, PrintWriter out) {
        try {
            int numberOfEntries = 0;
            for (FieldConnectionEntry entry : connectionEntries) {
                if (entry.isDynamic()) continue;
                ++numberOfEntries;
            }
            out.println(numberOfEntries);
            for (FieldConnectionEntry entry : connectionEntries) {
                String encrypted;
                if (entry.isDynamic()) continue;
                out.println(entry.getName());
                out.println(entry.getProperties().getName());
                out.println(entry.getHost());
                out.println(entry.getPort());
                out.println(entry.getDatabase());
                out.println(entry.getUser());
                try {
                    encrypted = CipherTools.encrypt(new String(entry.getPassword()));
                }
                catch (CipherException e) {
                    LogService.getRoot().log(Level.WARNING, "Failed to write database connections file: " + e, e);
                    encrypted = null;
                }
                out.println(encrypted);
            }
            out.close();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static Document toXML(Collection<FieldConnectionEntry> connectionEntries, Key key, String replacementForLocalhost) throws ParserConfigurationException, DOMException, CipherException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("jdbc-entries");
        String base64key = Base64.encodeBytes(key.getEncoded());
        root.setAttribute("key", base64key);
        doc.appendChild(root);
        for (FieldConnectionEntry entry : connectionEntries) {
            root.appendChild(entry.toXML(doc, key, replacementForLocalhost));
        }
        return doc;
    }

    public static Collection<FieldConnectionEntry> parseEntries(Element entries) throws XMLException, CipherException, IOException {
        if (!entries.getTagName().equals("jdbc-entries")) {
            throw new XMLException("Outer tag must be <jdbc-entries>");
        }
        String base64Key = entries.getAttribute("key");
        if (base64Key == null) {
            throw new XMLException("Cipher key attribute missing.");
        }
        SecretKeySpec key = KeyGeneratorTool.makeKey(Base64.decode(base64Key));
        LinkedList<FieldConnectionEntry> result = new LinkedList<FieldConnectionEntry>();
        NodeList children = entries.getElementsByTagName("field-entry");
        for (int i = 0; i < children.getLength(); ++i) {
            result.add(new FieldConnectionEntry((Element)children.item(i), key));
        }
        return result;
    }

    public static boolean testConnection(ConnectionEntry entry) throws SQLException {
        if (entry != null) {
            if (handler != null) {
                handler.disconnect();
            }
            if ((handler = DatabaseHandler.getConnectedDatabaseHandler(entry)) != null) {
                handler.disconnect();
            }
            return true;
        }
        return false;
    }
}

