/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc.connection;

import com.rapidminer.tools.jdbc.JDBCProperties;
import java.util.Comparator;

public abstract class ConnectionEntry
implements Comparable {
    public static Comparator<ConnectionEntry> COMPARATOR = new Comparator<ConnectionEntry>(){

        @Override
        public int compare(ConnectionEntry o1, ConnectionEntry o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    protected String name;
    protected JDBCProperties properties;
    protected String user = null;
    protected char[] password = null;

    public ConnectionEntry() {
        this("", JDBCProperties.createDefaultJDBCProperties());
    }

    public ConnectionEntry(String name, JDBCProperties properties) {
        this.name = name;
        this.properties = properties;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((ConnectionEntry)o).name);
    }

    public String getName() {
        return this.name;
    }

    public JDBCProperties getProperties() {
        return this.properties;
    }

    public String getUser() {
        return this.user;
    }

    public char[] getPassword() {
        return this.password;
    }

    public abstract String getURL();

    public String toString() {
        return this.name;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }
}

