/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.jdbc.DataTypeSyntaxInformation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class StatementCreator {
    private Map<Integer, DataTypeSyntaxInformation> typeMap = new LinkedHashMap<Integer, DataTypeSyntaxInformation>();
    private String identifierQuote;
    private long defaultVarCharLength = -1L;

    public StatementCreator(Connection connection) throws SQLException {
        this(connection, -1L);
    }

    StatementCreator(Connection connection, long defaultVarcharLength) throws SQLException {
        this.defaultVarCharLength = defaultVarcharLength;
        this.buildTypeMap(connection);
    }

    public void setDefaultVarcharLength(long defaultVarcharLength) {
        this.defaultVarCharLength = defaultVarcharLength;
    }

    private void buildTypeMap(Connection con) throws SQLException {
        DatabaseMetaData dbMetaData = con.getMetaData();
        this.identifierQuote = dbMetaData.getIdentifierQuoteString();
        LogService.getRoot().fine("Identifier quote character is: " + this.identifierQuote);
        HashMap<Integer, DataTypeSyntaxInformation> dataTypeToMDMap = new HashMap<Integer, DataTypeSyntaxInformation>();
        ResultSet typesResult = dbMetaData.getTypeInfo();
        while (typesResult.next()) {
            DataTypeSyntaxInformation dtmd = new DataTypeSyntaxInformation(typesResult);
            if (dataTypeToMDMap.containsKey(dtmd.getDataType())) continue;
            dataTypeToMDMap.put(dtmd.getDataType(), dtmd);
        }
        this.registerSyntaxInfo(1, dataTypeToMDMap, 12);
        this.registerSyntaxInfo(5, dataTypeToMDMap, 2005, 2004, -1, -16, 12);
        this.registerSyntaxInfo(4, dataTypeToMDMap, 8, 7, 6);
        this.registerSyntaxInfo(2, dataTypeToMDMap, 8, 7, 6);
        this.registerSyntaxInfo(3, dataTypeToMDMap, 4);
        this.registerSyntaxInfo(10, dataTypeToMDMap, 91, 93);
        this.registerSyntaxInfo(9, dataTypeToMDMap, 93);
        this.registerSyntaxInfo(11, dataTypeToMDMap, 92, 93);
        this.registerSyntaxInfo(0, dataTypeToMDMap, 8, 7, 6);
        this.registerSyntaxInfo(6, dataTypeToMDMap, 12);
    }

    private void registerSyntaxInfo(int attributeType, Map<Integer, DataTypeSyntaxInformation> dataTypeToMDMap, int ... possibleDataTypes) throws SQLException {
        for (int i : possibleDataTypes) {
            DataTypeSyntaxInformation si = dataTypeToMDMap.get(i);
            if (si == null) continue;
            this.typeMap.put(attributeType, si);
            LogService.getRoot().fine("Mapping " + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attributeType) + " to " + si);
            return;
        }
        LogService.getRoot().warning("No SQL value type found for " + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attributeType));
    }

    private String mapAttributeTypeToSQLDataType(int type) {
        DataTypeSyntaxInformation typeStr = this.getSQLTypeForRMValueType(type);
        return typeStr.getTypeName();
    }

    DataTypeSyntaxInformation getSQLTypeForRMValueType(int type) {
        int parent = type;
        while (parent != 0) {
            DataTypeSyntaxInformation si = this.typeMap.get(parent);
            if (si != null) {
                return si;
            }
            parent = Ontology.ATTRIBUTE_VALUE_TYPE.getParent(parent);
        }
        throw new NoSuchElementException("No SQL type mapped to attribute type " + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(type));
    }

    public String makeTableCreator(Attributes attributes, String tableName, int defaultVarcharLength) throws SQLException {
        this.defaultVarCharLength = defaultVarcharLength;
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE ");
        b.append(this.makeIdentifier(tableName));
        b.append(" (");
        Iterator<AttributeRole> a = attributes.allAttributeRoles();
        boolean first = true;
        while (a.hasNext()) {
            if (!first) {
                b.append(", ");
            }
            first = false;
            AttributeRole attributeRole = a.next();
            this.makeColumnCreator(b, attributeRole);
        }
        Attribute idAttribute = attributes.getId();
        if (idAttribute != null) {
            b.append(", PRIMARY KEY( ");
            b.append(this.makeColumnIdentifier(idAttribute));
            b.append(")");
        }
        b.append(")");
        return b.toString();
    }

    public String makeIdentifier(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("Identifier must not be null");
        }
        if (this.identifierQuote != null) {
            switch (this.identifierQuote.length()) {
                case 0: {
                    break;
                }
                case 1: {
                    identifier = identifier.replace(this.identifierQuote.charAt(0), '_');
                    break;
                }
                default: {
                    identifier = identifier.replace(this.identifierQuote, "_");
                }
            }
        }
        return this.identifierQuote + identifier + this.identifierQuote;
    }

    public String makeInsertStatement(String tableName, ExampleSet exampleSet) throws SQLException {
        StringBuffer b = new StringBuffer("INSERT INTO ");
        b.append(this.makeIdentifier(tableName));
        b.append(" (");
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        boolean first = true;
        while (a.hasNext()) {
            Attribute attribute = a.next();
            if (!first) {
                b.append(", ");
            }
            b.append(this.makeColumnIdentifier(attribute));
            first = false;
        }
        b.append(")");
        b.append(" VALUES (");
        int size = exampleSet.getAttributes().allSize();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            b.append("?");
        }
        b.append(")");
        return b.toString();
    }

    public void makeColumnAlter(StringBuilder b, AttributeRole role) throws SQLException {
        b.append("ALTER ");
        this.makeColumnCreator(b, role);
    }

    public void makeColumnAdd(StringBuilder b, AttributeRole role) throws SQLException {
        b.append("ADD ");
        this.makeColumnCreator(b, role);
    }

    public void makeColumnDrop(StringBuilder b, Attribute attribute) throws SQLException {
        b.append("DROP ");
        b.append(this.makeColumnIdentifier(attribute));
        b.append(" CASCADE");
    }

    private void makeColumnCreator(StringBuilder b, AttributeRole role) throws SQLException {
        Attribute attribute = role.getAttribute();
        b.append(this.makeColumnIdentifier(attribute));
        b.append(" ");
        DataTypeSyntaxInformation si = this.getSQLTypeForRMValueType(attribute.getValueType());
        b.append(si.getTypeName());
        if (attribute.isNominal()) {
            if (si.getPrecision() > 0L && this.defaultVarCharLength > si.getPrecision()) {
                throw new SQLException("minimum requested varchar length >" + si.getPrecision() + " which is the maximum length for columns of SQL type " + si.getTypeName());
            }
            int maxLength = 1;
            for (String value : attribute.getMapping().getValues()) {
                int length = value.length();
                if (length <= maxLength) continue;
                maxLength = length;
                if (si.getPrecision() > 0L && (long)length > si.getPrecision()) {
                    throw new SQLException("Attribute " + attribute.getName() + " contains values with length >" + si.getPrecision() + " which is the maximum length for columns of SQL type " + si.getTypeName());
                }
                if (this.defaultVarCharLength == -1L || (long)maxLength <= this.defaultVarCharLength) continue;
                throw new SQLException("Attribute " + attribute.getName() + " contains values with length >" + this.defaultVarCharLength + " which is the requested default varchar length.");
            }
            if (si.getTypeName().toLowerCase().startsWith("varchar")) {
                if (this.defaultVarCharLength != -1L && this.defaultVarCharLength < (long)maxLength) {
                    b.append("(").append(this.defaultVarCharLength).append(")");
                } else {
                    b.append("(").append(maxLength).append(")");
                }
            }
        }
        if (role.isSpecial() && role.getSpecialName().equals("id")) {
            b.append(" NOT NULL");
        }
    }

    private void makeColumnCreator(StringBuilder b, Attribute attribute) {
        b.append(this.makeColumnIdentifier(attribute));
        b.append(" ");
        b.append(this.mapAttributeTypeToSQLDataType(attribute.getValueType()));
    }

    public String makeColumnCreator(Attribute attribute) {
        StringBuilder b = new StringBuilder();
        this.makeColumnCreator(b, attribute);
        return b.toString();
    }

    public String makeColumnIdentifier(Attribute attribute) {
        return this.makeIdentifier(attribute.getName());
    }

    public String makeDropStatement(String tableName) {
        return "DROP TABLE " + this.makeIdentifier(tableName);
    }

    public String makeDeleteStatement(String tableName) {
        return "DELETE FROM " + this.makeIdentifier(tableName);
    }

    public String makeSelectAllStatement(String tableName) {
        return "SELECT * FROM " + this.makeIdentifier(tableName);
    }

    public String makeSelectStatement(String tableName, boolean distinct, String ... columns) {
        StringBuilder b = new StringBuilder("SELECT ");
        if (distinct) {
            b.append(" DISTINCT ");
        }
        boolean first = true;
        for (String col : columns) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(this.makeIdentifier(col));
        }
        b.append(" FROM ");
        b.append(this.makeIdentifier(tableName));
        return b.toString();
    }

    public String makeSelectSizeStatement(String tableName) {
        return "SELECT count(*) FROM " + this.makeIdentifier(tableName);
    }

    @Deprecated
    public String makeSelectEmptySetStatement(String tableName) {
        return "SELECT * FROM " + this.makeIdentifier(tableName) + " WHERE 1=0";
    }

    public String makeClobCreator(String columnName, int minLength) {
        StringBuilder b = new StringBuilder();
        b.append(this.makeIdentifier(columnName)).append(" ");
        String typeString = this.mapAttributeTypeToSQLDataType(5);
        b.append(typeString);
        if (typeString.toLowerCase().startsWith("varchar")) {
            if (minLength != -1) {
                b.append("(").append(minLength).append(")");
            } else {
                b.append("(").append(this.defaultVarCharLength).append(")");
            }
        }
        return b.toString();
    }

    public String makeVarcharCreator(String columnName, int minLength) {
        if (minLength == 0) {
            minLength = 1;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.makeIdentifier(columnName)).append(" ");
        String typeString = this.mapAttributeTypeToSQLDataType(1);
        b.append(typeString);
        if (typeString.toLowerCase().startsWith("varchar")) {
            if (minLength != -1) {
                b.append("(").append(minLength).append(")");
            } else {
                b.append("(").append(this.defaultVarCharLength).append(")");
            }
        }
        return b.toString();
    }

    public String makeIntegerCreator(String columnName) {
        StringBuilder b = new StringBuilder();
        b.append(this.makeIdentifier(columnName)).append(" ");
        String typeString = this.mapAttributeTypeToSQLDataType(3);
        b.append(typeString);
        return b.toString();
    }
}

