/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DriverAdapter;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JDBCProperties {
    private String name;
    private String defaultPort;
    private String urlPrefix;
    private String dbNameSeperator;
    private String[] drivers;
    private String driverJarFile;
    private boolean userDefined;

    private JDBCProperties() {
        this(false);
    }

    public JDBCProperties(boolean userDefined) {
        this.setName("unknown");
        this.setDefaultPort("port");
        this.setUrlPrefix("urlprefix://");
        this.dbNameSeperator = "/";
        this.userDefined = userDefined;
    }

    public JDBCProperties(Element driverElement, boolean userDefined) throws Exception {
        this.userDefined = userDefined;
        Attr nameAttr = driverElement.getAttributeNode("name");
        Attr driversAttr = driverElement.getAttributeNode("drivers");
        Attr portAttr = driverElement.getAttributeNode("defaultport");
        Attr urlAttr = driverElement.getAttributeNode("urlprefix");
        Attr dbNameAttr = driverElement.getAttributeNode("dbnameseparator");
        if (dbNameAttr == null) {
            dbNameAttr = driverElement.getAttributeNode("dbnameseperator");
        }
        Attr driverJarAttr = driverElement.getAttributeNode("driver_jar");
        if (nameAttr == null) {
            throw new Exception("Missing name for <driver> tag");
        }
        this.setName(nameAttr.getValue());
        if (portAttr == null) {
            throw new Exception("Missing defaultport for <driver> tag for driver '" + this.getName() + "'");
        }
        if (urlAttr == null) {
            throw new Exception("Missing urlprefix for <driver> tag for driver '" + this.getName() + "'");
        }
        if (driversAttr == null) {
            LogService.getRoot().warning("Missing database driver class name for '" + this.getName() + "'");
        }
        this.setDefaultPort(portAttr.getValue());
        this.setUrlPrefix(urlAttr.getValue());
        String string = this.dbNameSeperator = dbNameAttr != null ? dbNameAttr.getValue() : "/";
        if (driversAttr != null) {
            String value = driversAttr.getValue();
            this.setDriverClasses(value);
        } else {
            this.drivers = new String[0];
        }
        if (driverJarAttr != null) {
            this.setDriverJarFile(driverJarAttr.getValue());
        } else {
            this.setDriverJarFile(null);
        }
    }

    public void setDriverClasses(String value) {
        this.drivers = value == null ? new String[0] : value.split("\\s*,\\s*");
    }

    public void merge(JDBCProperties other) {
        if (other.getDefaultPort() != null) {
            this.setDefaultPort(other.getDefaultPort());
        }
        if (other.getUrlPrefix() != null) {
            this.setUrlPrefix(other.getUrlPrefix());
        }
        if (other.dbNameSeperator != null) {
            this.dbNameSeperator = other.dbNameSeperator;
        }
        boolean bl = this.userDefined = this.userDefined || other.userDefined;
        if (other.getDriverJarFile() != null) {
            if (this.getDriverJarFile() == null) {
                this.setDriverJarFile(other.getDriverJarFile());
            } else {
                this.setDriverJarFile(other.getDriverJarFile() + "," + this.getDriverJarFile());
            }
        }
        if (other.drivers != null) {
            if (this.drivers == null) {
                this.drivers = other.drivers;
            } else {
                HashSet<String> merged = new HashSet<String>();
                merged.addAll(Arrays.asList(this.drivers));
                merged.addAll(Arrays.asList(other.drivers));
                this.drivers = merged.toArray(new String[merged.size()]);
            }
        }
    }

    public String getDbNameSeperator() {
        return this.dbNameSeperator;
    }

    public String getDefaultPort() {
        return this.defaultPort;
    }

    public String getName() {
        return this.name;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public static JDBCProperties createDefaultJDBCProperties() {
        return new JDBCProperties();
    }

    public void registerDrivers() {
        for (String driverName : this.drivers) {
            try {
                ClassLoader loader;
                if (this.getDriverJarFile() != null) {
                    String[] jarNames = this.getDriverJarFile().split(",");
                    final URL[] urls = new URL[jarNames.length];
                    for (int i = 0; i < jarNames.length; ++i) {
                        File jarFile = new File(jarNames[i]);
                        if (!jarFile.exists()) {
                            LogService.getRoot().warning("Driver jar file '" + jarFile.getAbsolutePath() + "' referenced for JDBC driver " + this.getName() + " does not exist.");
                        }
                        urls[i] = jarFile.toURI().toURL();
                    }
                    loader = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() throws Exception {
                            return new URLClassLoader(urls);
                        }
                    });
                } else {
                    loader = this.getClass().getClassLoader();
                }
                if (this.getDriverJarFile() == null) {
                    Class.forName(driverName, true, loader);
                } else {
                    DriverManager.registerDriver(new DriverAdapter((Driver)Class.forName(driverName, true, loader).newInstance()));
                }
                if (this.getDriverJarFile() != null) {
                    LogService.getRoot().config("Loaded JDBC driver " + driverName + " from " + this.getDriverJarFile());
                    continue;
                }
                LogService.getRoot().config("Loaded JDBC driver " + driverName);
            }
            catch (ClassNotFoundException e) {
                if (this.getDriverJarFile() != null) {
                    LogService.getRoot().info("JDBC driver " + driverName + " not found in " + this.getDriverJarFile());
                    continue;
                }
                LogService.getRoot().info("JDBC driver " + driverName + " not found. Probably the driver is not installed.");
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to register JDBC driver " + driverName + ": " + e, e);
            }
        }
    }

    public String[] getDriverClasses() {
        return this.drivers;
    }

    public String getDriverJarFile() {
        return this.driverJarFile;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultPort(String defaultPort) {
        this.defaultPort = defaultPort;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public void setDriverJarFile(String driverJarFile) {
        this.driverJarFile = driverJarFile;
    }

    public void setDbNameSeperator(String dbNameSeperator) {
        this.dbNameSeperator = dbNameSeperator;
    }

    public Element getXML(Document doc) {
        Element element = doc.createElement("driver");
        element.setAttribute("name", this.getName());
        element.setAttribute("drivers", Tools.toString(this.drivers, ","));
        element.setAttribute("driver_jar", this.getDriverJarFile());
        element.setAttribute("defaultport", this.getDefaultPort());
        element.setAttribute("urlprefix", this.getUrlPrefix());
        element.setAttribute("dbnameseparator", this.getDbNameSeperator());
        return element;
    }
}

