/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.tools.jdbc.DriverAdapter;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.sql.Driver;

public class DriverInfo
implements Comparable<DriverInfo> {
    private final Driver driver;
    private JDBCProperties properties;

    public DriverInfo(Driver driver, JDBCProperties properties) {
        this.driver = driver;
        this.properties = properties;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public String getShortName() {
        if (this.properties != null) {
            return this.properties.getName();
        }
        return "Unknown";
    }

    public String getClassName() {
        if (this.driver != null) {
            if (this.driver instanceof DriverAdapter) {
                return ((DriverAdapter)this.driver).toLongString();
            }
            return this.driver.getClass().getName();
        }
        return null;
    }

    public String toString() {
        return this.getShortName() + " (" + this.getClassName() + ")";
    }

    @Override
    public int compareTo(DriverInfo o) {
        int c = this.getShortName().compareTo(o.getShortName());
        if (c != 0) {
            return c;
        }
        String cn1 = this.getClassName();
        String cn2 = o.getClassName();
        if (cn1 != null && cn2 != null) {
            return cn1.compareTo(cn2);
        }
        if (cn1 == null) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DriverInfo)) {
            return false;
        }
        DriverInfo a = (DriverInfo)o;
        if (!this.getShortName().equals(a.getShortName())) {
            return false;
        }
        return a.getDriver() == this.getDriver();
    }

    public int hashCode() {
        return this.getShortName().hashCode();
    }

    public JDBCProperties getProperties() {
        return this.properties;
    }
}

