/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.RapidMiner;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.jdbc.DriverInfo;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseService {
    private static List<JDBCProperties> jdbcProperties = new ArrayList<JDBCProperties>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        URL propertyURL = Tools.getResource("jdbc_properties.xml");
        if (propertyURL != null) {
            InputStream in = null;
            try {
                in = propertyURL.openStream();
                DatabaseService.loadJDBCProperties(in, "resource jdbc_properties.xml", false);
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot load JDBC properties from program resources.", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LogService.getRoot().log(Level.WARNING, "Cannot close connection for JDBC properties file in the resources.", e);
                    }
                }
            }
        }
        if (RapidMiner.getExecutionMode().canAccessFilesystem()) {
            File userProperties;
            File globalJDBCFile = ParameterService.getGlobalConfigFile("jdbc_properties.xml");
            if (globalJDBCFile != null) {
                DatabaseService.loadJDBCProperties(globalJDBCFile, false);
            }
            if ((userProperties = DatabaseService.getUserJDBCPropertiesFile()) != null && userProperties.exists()) {
                DatabaseService.loadJDBCProperties(userProperties, true);
            }
        } else {
            LogService.getRoot().config("Ignoring jdbc_properties.xml files in execution mode " + (Object)((Object)RapidMiner.getExecutionMode()) + ".");
        }
    }

    private static File getUserJDBCPropertiesFile() {
        return ParameterService.getUserConfigFile("jdbc_properties.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJDBCProperties(File jdbcProperties, boolean userDefined) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(jdbcProperties);
            DatabaseService.loadJDBCProperties(in, jdbcProperties.getAbsolutePath(), userDefined);
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot load JDBC properties from etc directory.", e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot close connection for JDBC properties file in the etc directory.", e);
                }
            }
        }
    }

    public static void loadJDBCProperties(InputStream in, String name, boolean userDefined) {
        LogService.getRoot().config("Loading JDBC driver information from '" + name + "'.");
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot read JDBC driver description file '" + name + "': no valid XML: " + e.getMessage(), e);
        }
        if (document != null) {
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("drivers")) {
                LogService.getRoot().log(Level.WARNING, "JDBC driver description file '" + name + "': outermost tag must be <drivers>!");
                return;
            }
            NodeList driverTags = document.getDocumentElement().getElementsByTagName("driver");
            for (int i = 0; i < driverTags.getLength(); ++i) {
                Element currentElement = (Element)driverTags.item(i);
                try {
                    DatabaseService.addDriverInformation(currentElement, userDefined);
                    continue;
                }
                catch (Exception e) {
                    Attr currentNameAttr = currentElement.getAttributeNode("name");
                    if (currentNameAttr != null) {
                        LogService.getRoot().log(Level.WARNING, "JDBC driver description: cannot register '" + currentNameAttr.getValue() + "': " + e, e);
                        continue;
                    }
                    LogService.getRoot().log(Level.WARNING, "JDBC driver registration: cannot register '" + currentElement + "': " + e, e);
                }
            }
        }
    }

    private static void addDriverInformation(Element driverElement, boolean userDefined) throws Exception {
        JDBCProperties properties = new JDBCProperties(driverElement, userDefined);
        properties.registerDrivers();
        for (JDBCProperties other : jdbcProperties) {
            if (!other.getName().equals(properties.getName())) continue;
            LogService.getRoot().config("Merging jdbc driver information for " + other.getName());
            other.merge(properties);
            return;
        }
        jdbcProperties.add(properties);
    }

    private static Enumeration<Driver> getAllDrivers() {
        return DriverManager.getDrivers();
    }

    public static DriverInfo[] getAllDriverInfos() {
        boolean accepted;
        LinkedList<DriverInfo> predefinedDriverList = new LinkedList<DriverInfo>();
        for (JDBCProperties properties : DatabaseService.getJDBCProperties()) {
            Enumeration<Driver> drivers = DatabaseService.getAllDrivers();
            accepted = false;
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                try {
                    if (!driver.acceptsURL(properties.getUrlPrefix())) continue;
                    DriverInfo info = new DriverInfo(driver, properties);
                    predefinedDriverList.add(info);
                    accepted = true;
                    break;
                }
                catch (SQLException e) {
                }
            }
            if (accepted) continue;
            predefinedDriverList.add(new DriverInfo(null, properties));
        }
        LinkedList<DriverInfo> driverList = new LinkedList<DriverInfo>();
        Enumeration<Driver> drivers = DatabaseService.getAllDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            accepted = true;
            for (DriverInfo predefinedInfo : predefinedDriverList) {
                if (predefinedInfo.getDriver() == null || !predefinedInfo.getDriver().equals(driver)) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            driverList.add(new DriverInfo(driver, null));
        }
        driverList.addAll(predefinedDriverList);
        Collections.sort(driverList);
        DriverInfo[] driverArray = new DriverInfo[driverList.size()];
        driverList.toArray(driverArray);
        return driverArray;
    }

    public static JDBCProperties getJDBCProperties(String name) {
        for (JDBCProperties properties : jdbcProperties) {
            if (!properties.getName().equals(name)) continue;
            return properties;
        }
        return null;
    }

    public static List<JDBCProperties> getJDBCProperties() {
        return jdbcProperties;
    }

    public static void addJDBCProperties(JDBCProperties newProps) {
        jdbcProperties.add(newProps);
    }

    public static void removeJDBCProperties(JDBCProperties newProps) {
        jdbcProperties.remove(newProps);
    }

    public static String[] getDBSystemNames() {
        String[] names = new String[jdbcProperties.size()];
        int counter = 0;
        Iterator<JDBCProperties> i = jdbcProperties.iterator();
        while (i.hasNext()) {
            names[counter++] = i.next().getName();
        }
        return names;
    }

    public static void saveUserDefinedProperties() throws XMLException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Failed to create document: " + e, e);
        }
        Element root = doc.createElement("drivers");
        doc.appendChild(root);
        for (JDBCProperties props : DatabaseService.getJDBCProperties()) {
            if (!props.isUserDefined()) continue;
            root.appendChild(props.getXML(doc));
        }
        XMLTools.stream(doc, DatabaseService.getUserJDBCPropertiesFile(), Charset.forName("UTF-8"));
    }
}

