/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDatabaseConnection;
import com.rapidminer.parameter.ParameterTypeDatabaseTable;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeSQLQuery;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.StatementCreator;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.DatabaseConnectionService;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DatabaseHandler {
    public static final String PARAMETER_DEFINE_CONNECTION = "define_connection";
    public static final String[] CONNECTION_MODES = new String[]{"predefined", "url", "jndi"};
    public static final int CONNECTION_MODE_PREDEFINED = 0;
    public static final int CONNECTION_MODE_URL = 1;
    public static final int CONNECTION_MODE_JNDI = 2;
    public static final String PARAMETER_CONNECTION = "connection";
    public static final String PARAMETER_DATABASE_SYSTEM = "database_system";
    public static final String PARAMETER_DATABASE_URL = "database_url";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_DEFINE_QUERY = "define_query";
    public static final String PARAMETER_JNDI_NAME = "jndi_name";
    public static final String[] QUERY_MODES = new String[]{"query", "query file", "table name"};
    public static final int QUERY_QUERY = 0;
    public static final int QUERY_FILE = 1;
    public static final int QUERY_TABLE = 2;
    public static final String PARAMETER_QUERY = "query";
    public static final String PARAMETER_QUERY_FILE = "query_file";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String[] OVERWRITE_MODES = new String[]{"none", "overwrite first, append then", "overwrite", "append"};
    public static final int OVERWRITE_MODE_NONE = 0;
    public static final int OVERWRITE_MODE_OVERWRITE_FIRST = 1;
    public static final int OVERWRITE_MODE_OVERWRITE = 2;
    public static final int OVERWRITE_MODE_APPEND = 3;
    private String databaseURL;
    private StatementCreator statementCreator;
    private String user;
    private Connection connection;
    public static final String PARAMETER_PARAMETERS = "parameters";
    public static final String PARAMETER_PREPARE_STATEMENT = "prepare_statement";
    private static final String[] SQL_TYPES = new String[]{"VARCHAR", "INTEGER", "REAL"};

    private DatabaseHandler(String databaseURL, String user) {
        this.databaseURL = databaseURL;
        this.user = user;
    }

    public static DatabaseHandler getConnectedDatabaseHandler(ConnectionEntry entry) throws SQLException {
        DatabaseHandler handler = new DatabaseHandler(entry.getURL(), entry.getUser());
        handler.connect(entry.getPassword(), true);
        return handler;
    }

    public static DatabaseHandler getHandler(Connection connection) throws OperatorException, SQLException {
        DatabaseHandler databaseHandler = new DatabaseHandler("preconnected", "unknown");
        databaseHandler.connection = connection;
        databaseHandler.statementCreator = new StatementCreator(connection);
        return databaseHandler;
    }

    public static DatabaseHandler getConnectedDatabaseHandler(String databaseURL, String username, String password) throws OperatorException, SQLException {
        return DatabaseHandler.getConnectedDatabaseHandler(databaseURL, username, password, true);
    }

    public static DatabaseHandler getConnectedDatabaseHandler(String databaseURL, String username, String password, boolean autoCommit) throws SQLException {
        if (password == null) {
            password = RapidMiner.getInputHandler().inputPassword("Password for user '" + username + "' required");
        }
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseURL, username);
        databaseHandler.connect(password.toCharArray(), autoCommit);
        return databaseHandler;
    }

    public StatementCreator getStatementCreator() {
        return this.statementCreator;
    }

    private void connect(char[] passwd, boolean autoCommit) throws SQLException {
        if (this.connection != null) {
            throw new SQLException("Connection to database '" + this.databaseURL + "' already exists!");
        }
        LogService.getRoot().config("Connecting to " + this.databaseURL + " as " + this.user + ".");
        DriverManager.setLoginTimeout(30);
        Properties props = new Properties();
        props.put("SetBigStringTryClob", "true");
        if (this.user != null && !this.user.isEmpty()) {
            props.put("user", this.user);
            props.put(PARAMETER_PASSWORD, new String(passwd));
        }
        this.connection = DriverManager.getConnection(this.databaseURL, props);
        this.connection.setAutoCommit(autoCommit);
        this.statementCreator = new StatementCreator(this.connection);
    }

    public void disconnect() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.unregister();
        }
    }

    private void unregister() {
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Statement createStatement(boolean scrollableAndUpdatable) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Could not create a statement for '" + this.databaseURL + "': not connected.");
        }
        Statement statement = null;
        statement = scrollableAndUpdatable ? this.connection.createStatement(1005, 1008) : this.connection.createStatement(1003, 1007);
        return statement;
    }

    public PreparedStatement createPreparedStatement(String sqlString, boolean scrollableAndUpdatable) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Could not create a prepared statement for '" + this.databaseURL + "': not connected.");
        }
        if (scrollableAndUpdatable) {
            return this.connection.prepareStatement(sqlString, 1005, 1008);
        }
        return this.connection.prepareStatement(sqlString, 1003, 1007);
    }

    public void commit() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Could not commit: no open connection to database '" + this.databaseURL + "' !");
        }
        this.connection.commit();
    }

    @Deprecated
    public ResultSet query(String sqlQuery) throws SQLException {
        if (!sqlQuery.toLowerCase().startsWith("select")) {
            throw new SQLException("Query: Only SQL-Statements starting with SELECT are allowed: " + sqlQuery);
        }
        Statement st = this.createStatement(true);
        ResultSet rs = st.executeQuery(sqlQuery);
        return rs;
    }

    public void addColumn(Attribute attribute, String tableName) throws SQLException {
        boolean exists = this.existsColumnInTable(tableName, attribute.getName());
        if (exists) {
            this.removeColumn(attribute, tableName);
        }
        Statement st = null;
        try {
            st = this.connection.createStatement(1003, 1008);
            String query = "ALTER TABLE " + this.statementCreator.makeIdentifier(tableName) + " ADD COLUMN " + this.statementCreator.makeColumnCreator(attribute);
            st.execute(query);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void removeColumn(Attribute attribute, String tableName) throws SQLException {
        Statement st = null;
        try {
            st = this.connection.createStatement(1003, 1008);
            String query = "ALTER TABLE " + this.statementCreator.makeIdentifier(tableName) + " DROP COLUMN " + this.statementCreator.makeColumnIdentifier(attribute);
            st.execute(query);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void dropTable(String tableName) throws SQLException {
        Statement statement = this.createStatement(true);
        statement.executeUpdate(this.statementCreator.makeDropStatement(tableName));
        statement.close();
    }

    public void emptyTable(String tableName) throws SQLException {
        Statement statement = this.createStatement(true);
        statement.executeUpdate(this.statementCreator.makeDeleteStatement(tableName));
        statement.close();
    }

    public void createTable(ExampleSet exampleSet, String tableName, int overwriteMode, boolean firstAttempt, int defaultVarcharLength) throws SQLException {
        this.createTable(exampleSet, tableName, overwriteMode, firstAttempt, defaultVarcharLength, false, "does_not_matter");
    }

    public void createTable(ExampleSet exampleSet, String tableName, int overwriteMode, boolean firstAttempt, int defaultVarcharLength, boolean addAutoGeneratedPrimaryKeys, String generatedPrimaryKeyAttributeName) throws SQLException {
        String createTableString;
        Statement statement = this.createStatement(true);
        boolean exists = this.existsTable(tableName);
        if (exists) {
            switch (overwriteMode) {
                case 0: {
                    throw new SQLException("Table with name '" + tableName + "' already exists and overwriting mode is not activated." + Tools.getLineSeparator() + "Please change table name or activate overwriting mode.");
                }
                case 2: {
                    statement.executeUpdate(this.statementCreator.makeDropStatement(tableName));
                    exampleSet.recalculateAllAttributeStatistics();
                    createTableString = this.statementCreator.makeTableCreator(exampleSet.getAttributes(), tableName, defaultVarcharLength);
                    statement.executeUpdate(createTableString);
                    statement.close();
                    break;
                }
                case 1: {
                    if (!firstAttempt) break;
                    statement.executeUpdate(this.statementCreator.makeDropStatement(tableName));
                    exampleSet.recalculateAllAttributeStatistics();
                    createTableString = this.statementCreator.makeTableCreator(exampleSet.getAttributes(), tableName, defaultVarcharLength);
                    statement.executeUpdate(createTableString);
                    statement.close();
                    break;
                }
            }
        } else {
            exampleSet.recalculateAllAttributeStatistics();
            createTableString = this.statementCreator.makeTableCreator(exampleSet.getAttributes(), tableName, defaultVarcharLength);
            statement.executeUpdate(createTableString);
            statement.close();
        }
        Attribute genPrimaryKeyAttribute = null;
        PreparedStatement insertStatement = this.getInsertIntoTableStatement(tableName, exampleSet, addAutoGeneratedPrimaryKeys);
        if (addAutoGeneratedPrimaryKeys) {
            genPrimaryKeyAttribute = AttributeFactory.createAttribute(generatedPrimaryKeyAttributeName, 3);
            exampleSet.getExampleTable().addAttribute(genPrimaryKeyAttribute);
            exampleSet.getAttributes().addRegular(genPrimaryKeyAttribute);
        }
        for (Example example : exampleSet) {
            this.applyInsertIntoTable(insertStatement, example, exampleSet.getAttributes().allAttributeRoles(), addAutoGeneratedPrimaryKeys, genPrimaryKeyAttribute);
        }
        insertStatement.close();
    }

    private PreparedStatement getInsertIntoTableStatement(String tableName, ExampleSet exampleSet, boolean addAutoGeneratedPrimaryKeys) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Could not create a prepared statement for '" + this.databaseURL + "': not connected.");
        }
        if (addAutoGeneratedPrimaryKeys) {
            return this.connection.prepareStatement(this.statementCreator.makeInsertStatement(tableName, exampleSet), 1);
        }
        return this.connection.prepareStatement(this.statementCreator.makeInsertStatement(tableName, exampleSet), 2);
    }

    private void applyInsertIntoTable(PreparedStatement statement, Example example, Iterator<AttributeRole> attributes, boolean addAutoGeneratedPrimaryKeys, Attribute genPrimaryKey) throws SQLException {
        int counter = 1;
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next().getAttribute();
            if (addAutoGeneratedPrimaryKeys && attribute == genPrimaryKey) continue;
            double value = example.getValue(attribute);
            if (Double.isNaN(value)) {
                int sqlType = this.statementCreator.getSQLTypeForRMValueType(attribute.getValueType()).getDataType();
                statement.setNull(counter, sqlType);
            } else if (attribute.isNominal()) {
                String valueString = attribute.getMapping().mapIndex((int)value);
                statement.setString(counter, valueString);
            } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 11)) {
                    statement.setTime(counter, new Time((long)value));
                } else {
                    statement.setTimestamp(counter, new Timestamp((long)value));
                }
            } else {
                statement.setDouble(counter, value);
            }
            ++counter;
        }
        statement.executeUpdate();
        if (addAutoGeneratedPrimaryKeys) {
            ResultSet generatedKeys = statement.getGeneratedKeys();
            if (!generatedKeys.next()) {
                throw new SQLException("The table does not contain a auto increment primary key. Please deactivate the Parameter \"add_generated_primary_keys\".");
            }
            int key = generatedKeys.getInt(1);
            example.setValue(genPrimaryKey, key);
        }
    }

    public static int getRapidMinerTypeIndex(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 3;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case -1: 
            case 2004: 
            case 2005: {
                return 5;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 1: 
            case 12: 
            case 2000: 
            case 2002: {
                return 1;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 11;
            }
            case 93: {
                return 9;
            }
        }
        return 1;
    }

    public static List<Attribute> createAttributes(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (rs == null) {
            throw new IllegalArgumentException("Cannot create attributes: ResultSet must not be null!");
        }
        try {
            metadata = rs.getMetaData();
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("Could not create attribute list: ResultSet object seems closed.");
        }
        int numberOfColumns = metadata.getColumnCount();
        for (int column = 1; column <= numberOfColumns; ++column) {
            String name = metadata.getColumnLabel(column);
            Attribute attribute = AttributeFactory.createAttribute(name, DatabaseHandler.getRapidMinerTypeIndex(metadata.getColumnType(column)));
            attributes.add(attribute);
        }
        return attributes;
    }

    private boolean existsTable(String tableName) throws SQLException {
        ResultSet tableNames = this.connection.getMetaData().getTables(null, null, tableName, null);
        return tableNames.next();
    }

    private boolean existsColumnInTable(String tableName, String columnName) throws SQLException {
        return this.connection.getMetaData().getColumns(null, null, tableName, columnName).next();
    }

    public Map<String, List<ColumnIdentifier>> getAllTableMetaData() throws SQLException {
        return this.getAllTableMetaData(null, 0, 0, true);
    }

    public Map<String, List<ColumnIdentifier>> getAllTableMetaData(ProgressListener progressListener, int minProgress, int maxProgress, boolean fetchColumns) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Could not retrieve all table names: no open connection to database '" + this.databaseURL + "' !");
        }
        if (this.connection.isClosed()) {
            this.unregister();
            throw new SQLException("Could not retrieve all table names: connection is closed.");
        }
        DatabaseMetaData metaData = this.connection.getMetaData();
        String[] types = !"false".equals(System.getProperty("rapidminer.tools.db.assist.show_only_standard_tables")) ? new String[]{"TABLE"} : null;
        ResultSet tableNames = metaData.getTables(null, null, null, types);
        LinkedList<String> tableNameList = new LinkedList<String>();
        while (tableNames.next()) {
            String tableName = tableNames.getString("TABLE_NAME");
            tableNameList.add(tableName);
        }
        tableNames.close();
        LinkedHashMap<String, List<ColumnIdentifier>> result = new LinkedHashMap<String, List<ColumnIdentifier>>();
        Iterator i = tableNameList.iterator();
        int size = tableNameList.size();
        int count = 0;
        while (i.hasNext()) {
            String tableName = (String)i.next();
            if (progressListener != null && size > 0) {
                progressListener.setCompleted(count * (maxProgress - minProgress) / size + minProgress);
            }
            ++count;
            if (fetchColumns) {
                try {
                    List<ColumnIdentifier> columnNames = this.getAllColumnNames(tableName, metaData);
                    result.put(tableName, columnNames);
                }
                catch (SQLException e) {
                    LogService.getRoot().log(Level.WARNING, "Failed to fetch column meta data for table '" + tableName + "': " + e, e);
                    result.put(tableName, Collections.emptyList());
                }
                continue;
            }
            result.put(tableName, Collections.emptyList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnIdentifier> getAllColumnNames(String tableName, DatabaseMetaData metaData) throws SQLException {
        if (tableName == null) {
            throw new SQLException("Cannot read column names: table name must not be null!");
        }
        Statement statement = null;
        ResultSet columnResult = null;
        ResultSet emptyQueryResult = null;
        try {
            statement = this.createStatement(false);
            try {
                columnResult = metaData.getColumns(null, null, tableName, "%");
                LinkedList<ColumnIdentifier> result = new LinkedList<ColumnIdentifier>();
                while (columnResult.next()) {
                    result.add(new ColumnIdentifier(this, tableName, columnResult.getString("COLUMN_NAME"), columnResult.getInt("DATA_TYPE"), columnResult.getString("TYPE_NAME")));
                }
                LinkedList<ColumnIdentifier> linkedList = result;
                return linkedList;
            }
            catch (SQLException e) {
                LinkedList<ColumnIdentifier> linkedList;
                block14: {
                    LinkedList<ColumnIdentifier> result = new LinkedList<ColumnIdentifier>();
                    String emptySelect = "SELECT * FROM " + this.statementCreator.makeIdentifier(tableName) + " WHERE 0=1";
                    emptyQueryResult = statement.executeQuery(emptySelect);
                    ResultSetMetaData resultSetMetaData = emptyQueryResult.getMetaData();
                    for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                        result.add(new ColumnIdentifier(this, tableName, resultSetMetaData.getColumnName(i + 1), resultSetMetaData.getColumnType(i + 1), resultSetMetaData.getColumnTypeName(i + 1)));
                    }
                    linkedList = result;
                    if (columnResult == null) break block14;
                    columnResult.close();
                }
                if (emptyQueryResult != null) {
                    emptyQueryResult.close();
                }
                if (statement != null) {
                    statement.close();
                }
                return linkedList;
            }
        }
        finally {
            if (columnResult != null) {
                columnResult.close();
            }
            if (emptyQueryResult != null) {
                emptyQueryResult.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static DatabaseHandler getConnectedDatabaseHandler(Operator operator) throws OperatorException, SQLException {
        switch (operator.getParameterAsInt(PARAMETER_DEFINE_CONNECTION)) {
            case 0: {
                ConnectionEntry entry = DatabaseConnectionService.getConnectionEntry(operator.getParameterAsString(PARAMETER_CONNECTION));
                if (entry == null) {
                    throw new UserError(operator, 318, operator.getParameterAsString(PARAMETER_CONNECTION));
                }
                return DatabaseHandler.getConnectedDatabaseHandler(entry.getURL(), entry.getUser(), new String(entry.getPassword()));
            }
            case 2: {
                String jndiName = operator.getParameterAsString(PARAMETER_JNDI_NAME);
                try {
                    InitialContext ctx = new InitialContext();
                    DataSource source = (DataSource)ctx.lookup(jndiName);
                    return DatabaseHandler.getHandler(source.getConnection());
                }
                catch (NamingException e) {
                    throw new OperatorException("Failed to lookup '" + jndiName + "': " + e, e);
                }
            }
        }
        return DatabaseHandler.getConnectedDatabaseHandler(operator.getParameterAsString(PARAMETER_DATABASE_URL), operator.getParameterAsString(PARAMETER_USERNAME), operator.getParameterAsString(PARAMETER_PASSWORD));
    }

    public static ConnectionEntry getConnectionEntry(Operator operator) {
        try {
            int connectionMode = operator.getParameterAsInt(PARAMETER_DEFINE_CONNECTION);
            switch (connectionMode) {
                case 0: {
                    return DatabaseConnectionService.getConnectionEntry(operator.getParameterAsString(PARAMETER_CONNECTION));
                }
                case 1: {
                    final String connectionUrl = operator.getParameterAsString(PARAMETER_DATABASE_URL);
                    final String connectionUsername = operator.getParameterAsString(PARAMETER_USERNAME);
                    final char[] connectionPassword = operator.getParameterAsString(PARAMETER_PASSWORD).toCharArray();
                    return new ConnectionEntry("urlConnection", DatabaseService.getJDBCProperties().get(operator.getParameterAsInt(PARAMETER_DATABASE_SYSTEM))){

                        @Override
                        public String getURL() {
                            return connectionUrl;
                        }

                        @Override
                        public String getUser() {
                            return connectionUsername;
                        }

                        @Override
                        public char[] getPassword() {
                            return connectionPassword;
                        }
                    };
                }
            }
            return null;
        }
        catch (UndefinedParameterError undefinedParameterError) {
            return null;
        }
    }

    public static List<ParameterType> getConnectionParameterTypes(ParameterHandler handler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_DEFINE_CONNECTION, "Indicates how the database connection should be specified.", CONNECTION_MODES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDatabaseConnection(PARAMETER_CONNECTION, "A predefined database connection.");
        type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_CONNECTION, CONNECTION_MODES, true, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_DATABASE_SYSTEM, "The used database system.", DatabaseService.getDBSystemNames(), 0);
        type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_CONNECTION, CONNECTION_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_DATABASE_URL, "The URL connection string for the database, e.g. 'jdbc:mysql://foo.bar:portnr/database'");
        type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_CONNECTION, CONNECTION_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_USERNAME, "The database username.");
        type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_CONNECTION, CONNECTION_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypePassword(PARAMETER_PASSWORD, "The password for the database.");
        type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_CONNECTION, CONNECTION_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_JNDI_NAME, "JNDI name for a data source.");
        type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_CONNECTION, CONNECTION_MODES, true, 2));
        type.setExpert(false);
        types.add(type);
        return types;
    }

    public static List<ParameterType> getQueryParameterTypes(ParameterHandler handler, boolean tableOnly) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = null;
        if (!tableOnly) {
            type = new ParameterTypeCategory(PARAMETER_DEFINE_QUERY, "Specifies whether the database query should be defined directly, through a file or implicitely by a given table name.", QUERY_MODES, 0);
            type.setExpert(false);
            types.add(type);
            type = new ParameterTypeSQLQuery(PARAMETER_QUERY, "An SQL query.");
            type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_QUERY, QUERY_MODES, true, 0));
            type.setExpert(false);
            types.add(type);
            type = new ParameterTypeFile(PARAMETER_QUERY_FILE, "A file containing an SQL query.", null, true);
            type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_QUERY, QUERY_MODES, true, 1));
            type.setExpert(false);
            types.add(type);
        }
        type = new ParameterTypeDatabaseTable(PARAMETER_TABLE_NAME, "A database table.");
        if (!tableOnly) {
            type.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_DEFINE_QUERY, QUERY_MODES, true, 2));
        }
        type.setExpert(false);
        types.add(type);
        return types;
    }

    public static List<ParameterType> getStatementPreparationParamterTypes(ParameterHandler handler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeBoolean prepareParam = new ParameterTypeBoolean(PARAMETER_PREPARE_STATEMENT, "If checked, the statement is prepared, and '?'-parameters can be filled in using the parameter 'parameters'.", false);
        types.add(prepareParam);
        ParameterTypeTupel argumentType = new ParameterTypeTupel("parameter", "Parameter to insert when statement is prepared", new ParameterTypeCategory("type", "SQL type to use for insertion.", SQL_TYPES, 0), new ParameterTypeString("parameter", "Parameter"));
        ParameterTypeEnumeration paramsParam = new ParameterTypeEnumeration(PARAMETER_PARAMETERS, "Parameters to insert into '?' placefholders when statement is prepared.", (ParameterType)argumentType);
        paramsParam.registerDependencyCondition(new BooleanParameterCondition(handler, PARAMETER_PREPARE_STATEMENT, false, true));
        types.add(paramsParam);
        return types;
    }

    public ResultSet executeStatement(String sql, boolean isQuery, Operator parameterHandler, Logger logger) throws SQLException, OperatorException {
        Statement statement;
        ResultSet resultSet = null;
        if (parameterHandler.getParameterAsBoolean(PARAMETER_PREPARE_STATEMENT)) {
            PreparedStatement prepared = this.getConnection().prepareStatement(sql);
            String[] parameters = ParameterTypeEnumeration.transformString2Enumeration(parameterHandler.getParameterAsString(PARAMETER_PARAMETERS));
            for (int i = 0; i < parameters.length; ++i) {
                String[] argDescription = ParameterTypeTupel.transformString2Tupel(parameters[i]);
                String sqlType = argDescription[0];
                String replacementValue = argDescription[1];
                if ("VARCHAR".equals(sqlType)) {
                    prepared.setString(i + 1, replacementValue);
                    continue;
                }
                if ("REAL".equals(sqlType)) {
                    try {
                        prepared.setDouble(i + 1, Double.parseDouble(replacementValue));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new UserError(parameterHandler, 158, replacementValue, sqlType);
                    }
                }
                if ("INTEGER".equals(sqlType)) {
                    try {
                        prepared.setInt(i + 1, Integer.parseInt(replacementValue));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new UserError(parameterHandler, 158, replacementValue, sqlType);
                    }
                }
                throw new OperatorException("Illegal data type: " + sqlType);
            }
            if (isQuery) {
                resultSet = prepared.executeQuery();
            } else {
                prepared.execute();
            }
            statement = prepared;
        } else {
            logger.info("Executing query: '" + sql + "'");
            statement = this.createStatement(false);
            if (isQuery) {
                resultSet = statement.executeQuery(sql);
            } else {
                statement.execute(sql);
            }
        }
        logger.info("Query executed.");
        if (!isQuery) {
            statement.close();
        }
        return resultSet;
    }
}

