/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.tools.jdbc.DatabaseHandler;

public class ColumnIdentifier {
    private final String tableName;
    private final String columnName;
    private final int sqlType;
    private final String sqlTypeName;
    private DatabaseHandler databaseHandler;

    public ColumnIdentifier(DatabaseHandler databaseHandler, String tableName, String columnName, int sqlType, String sqlTypeName) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.databaseHandler = databaseHandler;
        this.sqlType = sqlType;
        this.sqlTypeName = sqlTypeName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFullName(boolean singleTable) {
        if (singleTable) {
            return this.databaseHandler.getStatementCreator().makeIdentifier(this.columnName);
        }
        return this.databaseHandler.getStatementCreator().makeIdentifier(this.tableName + "." + this.columnName);
    }

    public String getAliasName(boolean singleTable) {
        if (singleTable) {
            return this.databaseHandler.getStatementCreator().makeIdentifier(this.columnName);
        }
        return this.databaseHandler.getStatementCreator().makeIdentifier(this.tableName + "__" + this.columnName);
    }

    public String toString() {
        return this.tableName + "." + this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getSqlTypeName() {
        return this.sqlTypeName;
    }
}

