/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.io;

import com.rapidminer.tools.GlobCompiler;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class GlobFilenameFilter
implements FilenameFilter {
    private Pattern filenamePattern;
    private boolean includeDirectories = false;

    public GlobFilenameFilter(String glob) {
        this.filenamePattern = GlobCompiler.compileGlob(glob);
    }

    public GlobFilenameFilter(String glob, boolean includeDirectories) {
        this.filenamePattern = GlobCompiler.compileGlob(glob);
        this.includeDirectories = includeDirectories;
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.filenamePattern.matcher(name.toLowerCase()).matches() && (this.includeDirectories || new File(dir, name).isFile());
    }
}

