/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.io;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Encoding {
    public static final String PARAMETER_ENCODING = "encoding";
    public static final String[] CHARSETS = new String[Charset.availableCharsets().size() + 1];

    public static Charset getEncoding(Operator handler) throws UndefinedParameterError, UserError {
        String selectedCharsetName = handler.getParameterAsString(PARAMETER_ENCODING);
        if ("SYSTEM".equals(selectedCharsetName)) {
            return Charset.defaultCharset();
        }
        try {
            return Charset.forName(selectedCharsetName);
        }
        catch (IllegalCharsetNameException e) {
            throw new UserError(handler, 207, selectedCharsetName, PARAMETER_ENCODING, "No legal charset name.");
        }
        catch (UnsupportedCharsetException e) {
            throw new UserError(handler, 207, selectedCharsetName, PARAMETER_ENCODING, "Charset not supported on this Java VM.");
        }
        catch (IllegalArgumentException e) {
            throw new UserError(handler, 207, selectedCharsetName, PARAMETER_ENCODING, "Select different charset.");
        }
    }

    public static Charset getEncoding(String charsetName) {
        if ("SYSTEM".equals(charsetName)) {
            return Charset.defaultCharset();
        }
        return Charset.forName(charsetName);
    }

    public static List<ParameterType> getParameterTypes(ParameterHandler handler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        String encoding = "SYSTEM";
        String encodingProperty = System.getProperty("rapidminer.general.encoding");
        if (encodingProperty != null) {
            encoding = encodingProperty;
        }
        types.add(new ParameterTypeStringCategory(PARAMETER_ENCODING, "The encoding used for reading or writing files.", CHARSETS, encoding, false));
        return types;
    }

    static {
        Encoding.CHARSETS[0] = "SYSTEM";
        int i = 0;
        Iterator<String> i$ = Charset.availableCharsets().keySet().iterator();
        while (i$.hasNext()) {
            String charSet;
            Encoding.CHARSETS[i + 1] = charSet = i$.next();
            ++i;
        }
    }
}

