/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.documentation;

import com.rapidminer.Process;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.documentation.ExampleProcess;
import com.rapidminer.tools.documentation.OperatorDocBundle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OperatorDocumentation {
    private final OperatorDocBundle operatorDocBundle;
    private String name;
    private String shortName;
    private String synopsis;
    private String documentation;
    private String deprecation;
    private final Element element;
    private final List<ExampleProcess> exampleProcesses = new LinkedList<ExampleProcess>();

    public OperatorDocumentation(String name) {
        this.name = this.shortName = name;
        this.synopsis = null;
        this.documentation = null;
        this.element = null;
        this.operatorDocBundle = null;
    }

    OperatorDocumentation(OperatorDocBundle operatorDocBundle, Element element) {
        this.operatorDocBundle = operatorDocBundle;
        this.name = XMLTools.getTagContents(element, "name");
        this.shortName = XMLTools.getTagContents(element, "shortName");
        this.synopsis = XMLTools.getTagContents(element, "synopsis");
        this.documentation = XMLTools.getTagContents(element, "help");
        this.deprecation = XMLTools.getTagContents(element, "deprecation");
        this.element = element;
        if (this.synopsis == null) {
            this.synopsis = "";
        }
        if (this.documentation == null) {
            this.documentation = this.synopsis;
        }
        NodeList exampleNodes = element.getElementsByTagName("example");
        for (int i = 0; i < exampleNodes.getLength(); ++i) {
            this.exampleProcesses.add(new ExampleProcess((Element)exampleNodes.item(i)));
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
        XMLTools.setTagContents(this.element, "name", name);
    }

    public String getShortName() {
        if (this.shortName != null) {
            return this.shortName;
        }
        return this.name;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
        if (this.element != null) {
            XMLTools.setTagContents(this.element, "shortName", shortName);
        }
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String text) {
        this.documentation = text;
        if (this.element != null) {
            XMLTools.setTagContents(this.element, "help", this.documentation);
        }
    }

    public void setSynopsis(String text) {
        this.synopsis = text;
        if (this.element != null) {
            XMLTools.setTagContents(this.element, "synopsis", text);
        }
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(String deprecation) {
        if (deprecation != null && (deprecation = deprecation.trim()).isEmpty()) {
            deprecation = null;
        }
        this.deprecation = deprecation;
        if (this.element != null) {
            XMLTools.setTagContents(this.element, "deprecation", deprecation);
        }
    }

    public void addExample(Process process, String comment) {
        Element exampleElement = this.element != null ? this.element.getOwnerDocument().createElement("example") : null;
        ExampleProcess exampleProcess = new ExampleProcess(exampleElement);
        exampleProcess.setProcessXML(process.getRootOperator().getXML(true));
        if (comment != null) {
            exampleProcess.setComment(comment);
        }
        if (this.element != null) {
            this.element.appendChild(exampleElement);
        }
        this.exampleProcesses.add(exampleProcess);
    }

    public List<ExampleProcess> getExamples() {
        return Collections.unmodifiableList(this.exampleProcesses);
    }

    public void removeExample(int index) {
        ExampleProcess process = this.exampleProcesses.get(index);
        if (this.element != null) {
            this.element.removeChild(process.getElement());
        }
        this.exampleProcesses.remove(index);
    }

    public OperatorDocBundle getBundle() {
        return this.operatorDocBundle;
    }
}

