/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.documentation;

import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.documentation.GroupDocumentation;
import com.rapidminer.tools.documentation.OperatorDocumentation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OperatorDocBundle
extends ResourceBundle {
    private final Map<String, OperatorDocumentation> operatorKeyDescriptionMap = new HashMap<String, OperatorDocumentation>();
    private final Map<String, GroupDocumentation> groupMap = new HashMap<String, GroupDocumentation>();
    private Document document;
    private final URL sourceUrl;
    private final String resourceName;

    public OperatorDocBundle(URL url, String resourceName) throws IOException {
        this.sourceUrl = url;
        this.resourceName = resourceName;
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(url.openStream());
        }
        catch (SAXException e) {
            throw new IOException("Malformed XML operator help bundle: " + e, e);
        }
        catch (ParserConfigurationException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot create XML parser: " + e, e);
            return;
        }
        NodeList helpElements = this.document.getDocumentElement().getElementsByTagName("operator");
        for (int i = 0; i < helpElements.getLength(); ++i) {
            Element element = (Element)helpElements.item(i);
            OperatorDocumentation oh = new OperatorDocumentation(this, element);
            try {
                String operatorKey = XMLTools.getTagContents(element, "key", false);
                if (operatorKey == null) {
                    operatorKey = XMLTools.getTagContents(element, "name", true);
                    LogService.getRoot().fine("Operator help is missing <key> tag. Using <name> as <key>: " + operatorKey);
                }
                this.operatorKeyDescriptionMap.put(operatorKey, oh);
                continue;
            }
            catch (XMLException e) {
                LogService.getRoot().log(Level.WARNING, "Malformed operoator documentation: " + e, e);
            }
        }
        NodeList groupElements = this.document.getDocumentElement().getElementsByTagName("group");
        for (int i = 0; i < groupElements.getLength(); ++i) {
            Element element = (Element)groupElements.item(i);
            GroupDocumentation doc = new GroupDocumentation(element);
            this.groupMap.put(doc.getKey(), doc);
        }
        LogService.getRoot().fine("Loaded documentation for " + this.operatorKeyDescriptionMap.size() + " operators and " + this.groupMap.size() + " groups.");
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.operatorKeyDescriptionMap.keySet());
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key.startsWith("operator.")) {
            OperatorDocumentation doc = this.operatorKeyDescriptionMap.get(key = key.substring("operator.".length()));
            if (doc == null) {
                Element element = this.document.createElement("operator");
                doc = new OperatorDocumentation(this, element);
                XMLTools.setTagContents(element, "key", key);
                this.document.getDocumentElement().appendChild(element);
                this.operatorKeyDescriptionMap.put(key, doc);
                LogService.getRoot().fine("Creating new empty documentation for operator " + key);
            }
            return doc;
        }
        if (key.startsWith("group.")) {
            GroupDocumentation groupDocumentation = this.groupMap.get(key = key.substring("group.".length()));
            if (groupDocumentation == null) {
                Element element = this.document.createElement("group");
                XMLTools.setTagContents(element, "key", key);
                String name = GroupDocumentation.keyToUpperCase(key);
                XMLTools.setTagContents(element, "name", name);
                this.document.getDocumentElement().appendChild(element);
                groupDocumentation = new GroupDocumentation(element);
                this.groupMap.put(key, groupDocumentation);
                LogService.getRoot().fine("Creating new empty documentation for group " + key);
            }
            return groupDocumentation;
        }
        return null;
    }

    public static OperatorDocBundle load(ClassLoader classLoader, String resource) {
        return (OperatorDocBundle)ResourceBundle.getBundle(resource, Locale.getDefault(), classLoader, new XMLControl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.sourceUrl.getProtocol().equals("file")) {
            LogService.getRoot().warning("Cannot save operator help. Operator help was not loaded from a file, but from " + this.sourceUrl.getProtocol() + ".");
        } else {
            OutputStream fos = null;
            try {
                if (this.sourceUrl.getProtocol().equals("file")) {
                    File buildFile = new File(this.sourceUrl.toURI());
                    LogService.getRoot().info("Saving operator help file to " + buildFile);
                    fos = new FileOutputStream(buildFile);
                    XMLTools.stream(this.document, fos, null);
                } else {
                    LogService.getRoot().info("Cannot save resources to " + this.sourceUrl + ": Not a file. Saving resources only works with development builds of RapidMiner.");
                }
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Cannot save operator documentation: " + e, e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e1) {}
                }
            }
            File sourceFile = ParameterService.getSourceResourceFile(this.resourceName);
            if (sourceFile == null || !sourceFile.exists()) {
                LogService.getRoot().info("Cannot save resource to file " + sourceFile + ": File does not exist. Saving resources only works with development builds of RapidMiner.");
            } else {
                LogService.getRoot().info("Saving operator help bundle to " + sourceFile);
                FileOutputStream sos = null;
                try {
                    sos = new FileOutputStream(sourceFile);
                    XMLTools.stream(this.document, sos, null);
                    ((OutputStream)sos).close();
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot save resources to " + this.sourceUrl + ": " + e, e);
                }
                finally {
                    if (sos != null) {
                        try {
                            ((OutputStream)sos).close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    public void check() {
        LogService.getRoot().info("Checking operator documentation");
        int missing = 0;
        int same = 0;
        int deprecation = 0;
        int different = 0;
        int empty = 0;
        for (Map.Entry<String, OperatorDocumentation> entry : this.operatorKeyDescriptionMap.entrySet()) {
            String string;
            String replacement;
            OperatorDescription desc;
            String key = entry.getKey();
            OperatorDocumentation doc = entry.getValue();
            if (key.startsWith("W-")) continue;
            if (doc.getDocumentation().trim().isEmpty()) {
                LogService.getRoot().warning("Empty documentation for " + key);
                ++empty;
            }
            if ((desc = OperatorService.getOperatorDescription(key)) == null) {
                ++missing;
                LogService.getRoot().warning("Documentation for nonexistent operator " + key);
            }
            if ((replacement = OperatorService.getReplacementForDeprecatedClass(key)) == null) continue;
            ++deprecation;
            OperatorDocumentation otherDoc = this.operatorKeyDescriptionMap.get(replacement);
            if (otherDoc != null) {
                if (otherDoc.getDocumentation().equals(doc.getDocumentation())) {
                    string = replacement + " has the same documentation entry.";
                    ++same;
                } else {
                    string = replacement + " has a different documentation entry.";
                    ++different;
                }
            } else {
                string = replacement + " has no documentation entry.";
            }
            LogService.getRoot().warning("Documentation for deprecated operator " + key + " replaced by " + replacement + ". " + string);
        }
        LogService.getRoot().info("Found " + empty + " empty documentations. Found documentation for " + missing + " nonexistent and " + deprecation + " replaced operators. Out of these, " + same + " documentations are identical to the documentation of the replacement and " + (deprecation - same - different) + " replacements have no documentation.");
    }

    public Document getDOMRepresentation() {
        return this.document;
    }

    private static class XMLControl
    extends ResourceBundle.Control {
        private XMLControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException("baseName is null.");
            }
            return Arrays.asList("xml");
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName;
            String resourceName;
            URL url;
            if (baseName == null || locale == null || format == null || loader == null) {
                throw new NullPointerException();
            }
            LogService.getRoot().fine("Looking up operator documentation for " + baseName + ", locale " + locale + ".");
            if (format.equals("xml") && (url = loader.getResource(resourceName = this.toResourceName(bundleName = this.toBundleName(baseName, locale), format))) != null) {
                LogService.getRoot().config("Loading operator documentation from " + url + ".");
                try {
                    return new OperatorDocBundle(url, resourceName);
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Exception creating OperatorDocBundle: " + e, e);
                    return null;
                }
            }
            return null;
        }
    }
}

