/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.documentation;

import com.rapidminer.io.process.XMLTools;
import org.w3c.dom.Element;

public class GroupDocumentation {
    private final String key;
    private final String name;
    private final String help;

    public GroupDocumentation(String key) {
        this.key = key;
        this.name = GroupDocumentation.keyToUpperCase(key);
        this.help = "The group " + this.name + "'.";
    }

    GroupDocumentation(Element element) {
        this.key = XMLTools.getTagContents(element, "key");
        this.name = XMLTools.getTagContents(element, "name");
        this.help = XMLTools.getTagContents(element, "help");
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help != null ? this.help : "";
    }

    public String toString() {
        return this.key + ": " + this.name;
    }

    public static String keyToUpperCase(String key) {
        String name = key;
        if (name.indexOf(46) >= 0) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        name = name.replace('_', ' ');
        char[] chars = name.toCharArray();
        boolean makeUppercase = true;
        for (int i = 0; i < chars.length; ++i) {
            if (makeUppercase) {
                chars[i] = Character.toUpperCase(chars[i]);
            }
            makeUppercase = Character.isWhitespace(chars[i]);
        }
        return new String(chars);
    }
}

