/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.documentation;

import com.rapidminer.Process;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class ExampleProcess {
    private String processXML;
    private String comment;
    private final Element element;

    public ExampleProcess(Element exampleElement) {
        this.element = exampleElement;
        if (this.element != null) {
            this.processXML = XMLTools.getTagContents(this.element, "process");
            this.comment = XMLTools.getTagContents(this.element, "comment");
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.element != null) {
            XMLTools.setTagContents(this.element, "comment", comment);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setProcessXML(String xml) {
        this.processXML = xml;
        if (this.element != null) {
            XMLTools.setTagContents(this.element, "process", xml);
        }
    }

    public String getProcessXML() {
        return this.processXML;
    }

    public Process getProcess() {
        try {
            return new Process(this.getProcessXML());
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot parse example process: " + e, e);
            return null;
        }
        catch (XMLException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot parse example process: " + e, e);
            return null;
        }
    }

    public Element getElement() {
        return this.element;
    }
}

