/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.container;

public class MultidimensionalArraySet<E> {
    private E[] array;
    private int[] dimensions;
    private int[] combinations;

    public MultidimensionalArraySet(int[] dimensions) {
        this.dimensions = dimensions;
        int splits = dimensions.length;
        int numberOfCombinations = 1;
        this.combinations = new int[splits];
        for (int i = splits - 1; i > 0; --i) {
            this.combinations[i - 1] = numberOfCombinations *= dimensions[i];
        }
        this.combinations[splits - 1] = 1;
        this.array = new Object[numberOfCombinations *= dimensions[0]];
    }

    public E get(int index) {
        return this.array[index];
    }

    public E get(int[] indices) {
        return this.array[this.getIndex(indices)];
    }

    public void set(int index, E e) {
        this.array[index] = e;
    }

    public void set(int[] indices, E e) {
        this.array[this.getIndex((int[])indices)] = e;
    }

    public int getIndex(int[] indices) {
        return this.sumProduct(indices, this.combinations);
    }

    public int[] getIndices(int index) {
        int[] indices = new int[this.combinations.length];
        int r = index;
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = r / this.combinations[i];
            r %= this.combinations[i];
        }
        return indices;
    }

    public int size() {
        return this.array.length;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    private int sumProduct(int[] firstIndices, int[] secondIndices) {
        int secondLength = secondIndices.length;
        int firstLength = firstIndices.length;
        int length = secondLength > firstLength ? firstLength : secondLength;
        int product = 0;
        for (int i = 0; i < length; ++i) {
            product += firstIndices[i] * secondIndices[i];
        }
        return product;
    }
}

