/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.cipher;

import com.rapidminer.RapidMiner;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.cipher.KeyGenerationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyGeneratorTool {
    private static final String GENERATOR_TYPE = "DESede";
    private static final String KEY_FILE_NAME = "cipher.key";

    public static SecretKey createSecretKey() throws KeyGenerationException {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(GENERATOR_TYPE);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyGenerationException("Cannot generate key, generation algorithm not known.");
        }
        keyGenerator.init(168, new SecureRandom());
        return keyGenerator.generateKey();
    }

    public static void createAndStoreKey() throws KeyGenerationException {
        if (!RapidMiner.getExecutionMode().canAccessFilesystem()) {
            LogService.getRoot().config("Skip key generation in execution mode " + (Object)((Object)RapidMiner.getExecutionMode()));
            return;
        }
        SecretKey key = KeyGeneratorTool.createSecretKey();
        File keyFile = new File(ParameterService.getUserRapidMinerDir(), KEY_FILE_NAME);
        if (!keyFile.delete()) {
            LogService.getRoot().warning("Failed to delete old key file.");
        }
        byte[] rawKey = key.getEncoded();
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(keyFile));
            out.writeInt(rawKey.length);
            out.write(rawKey);
            out.close();
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to generate key: " + e, e);
            throw new KeyGenerationException("Cannot store key: " + e.getMessage());
        }
    }

    public static Key getUserKey() throws IOException {
        File keyFile = new File(ParameterService.getUserRapidMinerDir(), KEY_FILE_NAME);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(keyFile));
            int length = in.readInt();
            byte[] rawKey = new byte[length];
            int actualLength = in.read(rawKey);
            if (length != actualLength) {
                throw new IOException("Cannot read key file (unexpected length)");
            }
            SecretKeySpec secretKeySpec = KeyGeneratorTool.makeKey(rawKey);
            return secretKeySpec;
        }
        catch (Exception e) {
            throw new IOException("Cannot retrieve key: " + e.getMessage());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static SecretKeySpec makeKey(byte[] rawKey) {
        return new SecretKeySpec(rawKey, GENERATOR_TYPE);
    }
}

