/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.cipher;

import com.rapidminer.io.Base64;
import com.rapidminer.tools.cipher.CipherException;
import com.rapidminer.tools.cipher.KeyGeneratorTool;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CipherTools {
    private static final String CIPHER_TYPE = "DESede";

    public static boolean isKeyAvailable() {
        try {
            KeyGeneratorTool.getUserKey();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String encrypt(String text) throws CipherException {
        Key key = null;
        try {
            key = KeyGeneratorTool.getUserKey();
        }
        catch (IOException e) {
            throw new CipherException("Cannot retrieve key, probably no one was created: " + e.getMessage());
        }
        return CipherTools.encrypt(text, key);
    }

    public static String encrypt(String text, Key key) throws CipherException {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(1, key);
            byte[] outputBytes = cipher.doFinal(text.getBytes());
            String base64 = Base64.encodeBytes(outputBytes);
            return base64;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherException("Failed to encrypt text: " + e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new CipherException("Failed to encrypt text: " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CipherException("Failed to encrypt text: " + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new CipherException("Failed to encrypt text: " + e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new CipherException("Failed to encrypt text: " + e.getMessage());
        }
    }

    public static String decrypt(String text) throws CipherException {
        Key key = null;
        try {
            key = KeyGeneratorTool.getUserKey();
        }
        catch (IOException e) {
            throw new CipherException("Cannot retrieve key, probably no one was created: " + e.getMessage());
        }
        return CipherTools.decrypt(text, key);
    }

    public static String decrypt(String text, Key key) throws CipherException {
        try {
            byte[] encrypted = Base64.decode(text);
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(2, key);
            byte[] outputBytes = cipher.doFinal(encrypted);
            String ret = new String(outputBytes);
            return ret;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherException("Failed to decrypt text: " + e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new CipherException("Failed to decrypt text: " + e.getMessage());
        }
        catch (IOException e) {
            throw new CipherException("Failed to decrypt text: " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CipherException("Failed to decrypt text: " + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new CipherException("Failed to decrypt text: " + e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new CipherException("Failed to decrypt text: " + e.getMessage());
        }
    }
}

