/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.att;

import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.RapidMinerLineReader;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.att.AttributeDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class AttributeDataSourceCreator {
    private ArrayList<AttributeDataSource> sources = new ArrayList();

    public List<AttributeDataSource> getAttributeDataSources() {
        return this.sources;
    }

    public void loadData(File file, char[] commentChars, String columnSeparators, char decimalPointCharacter, boolean useQuotes, char quoteChar, char escapeChar, boolean trimLines, boolean firstLineAsNames, int maxCounter, boolean skipErrorLines, Charset encoding, LoggingHandler logging) throws IOException {
        int i;
        String[] columns;
        this.sources.clear();
        String[] columnNames = null;
        int maxColumns = -1;
        int[] valueTypes = null;
        boolean[] onlyMissing = null;
        RapidMinerLineReader lineReader = new RapidMinerLineReader(columnSeparators, commentChars, useQuotes, quoteChar, escapeChar, trimLines, skipErrorLines);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        boolean first = true;
        for (int counter = 0; (maxCounter < 0 || counter <= maxCounter) && (columns = lineReader.readLine(in, -1)) != null; ++counter) {
            boolean lineOk = true;
            if (maxColumns != -1 && maxColumns != columns.length) {
                lineOk = false;
                if (skipErrorLines) {
                    if (logging != null) {
                        logging.logWarning("Number of columns in line " + counter + " was unexpected, was: " + columns.length + ", expected: " + maxColumns + ". Skipping line...");
                    }
                } else {
                    throw new IOException("Number of columns in line " + counter + " was unexpected, was: " + columns.length + ", expected: " + maxColumns);
                }
            }
            if (!lineOk) continue;
            if (first) {
                maxColumns = columns.length;
                valueTypes = new int[maxColumns];
                onlyMissing = new boolean[maxColumns];
                for (i = 0; i < valueTypes.length; ++i) {
                    valueTypes[i] = 3;
                    onlyMissing[i] = true;
                }
                if (firstLineAsNames) {
                    columnNames = columns;
                } else {
                    AttributeDataSourceCreator.guessValueTypes(columns, valueTypes, onlyMissing, decimalPointCharacter);
                }
                first = false;
                continue;
            }
            AttributeDataSourceCreator.guessValueTypes(columns, valueTypes, onlyMissing, decimalPointCharacter);
        }
        in.close();
        for (int i2 = 0; i2 < valueTypes.length; ++i2) {
            if (onlyMissing[i2] == false) continue;
            valueTypes[i2] = true;
        }
        if (columnNames == null) {
            String defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            columnNames = new String[maxColumns];
            for (int i3 = 0; i3 < columnNames.length; ++i3) {
                columnNames[i3] = defaultName + " (" + (i3 + 1) + ")";
            }
        } else if (columnNames.length < maxColumns) {
            String defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            String[] newColumnNames = new String[maxColumns];
            System.arraycopy(columnNames, 0, newColumnNames, 0, columnNames.length);
            for (i = columnNames.length; i < newColumnNames.length; ++i) {
                newColumnNames[i] = defaultName + " (" + (i + 1) + ")";
            }
        }
        for (int i4 = 0; i4 < maxColumns; ++i4) {
            this.sources.add(new AttributeDataSource(AttributeFactory.createAttribute(columnNames[i4], valueTypes[i4]), file, i4, "attribute"));
        }
    }

    public static void guessValueTypes(String[] data, int[] valueTypes, boolean[] onlyMissing, char decimalPointCharacter) {
        for (int c = 0; c < valueTypes.length; ++c) {
            String value = data[c];
            if (value == null || value.equals("?") || value.length() <= 0) continue;
            onlyMissing[c] = false;
            try {
                String valueString = value.replace(decimalPointCharacter, '.');
                double d = Double.parseDouble(valueString);
                if (valueTypes[c] != 3 || (double)((int)d) == d) continue;
                valueTypes[c] = 4;
                continue;
            }
            catch (NumberFormatException e) {
                valueTypes[c] = 1;
            }
        }
    }
}

