/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.NominalStatistics;
import com.rapidminer.example.NumericalStatistics;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.UnknownStatistics;
import com.rapidminer.example.WeightedNumericalStatistics;
import com.rapidminer.example.table.BinominalAttribute;
import com.rapidminer.example.table.BinominalMapping;
import com.rapidminer.example.table.NumericalAttribute;
import com.rapidminer.example.table.PolynominalAttribute;
import com.rapidminer.example.table.PolynominalMapping;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.tools.LogService;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.logging.Level;

public class XMLSerialization {
    private static ClassLoader classLoader;
    private XStream xStream;

    private XMLSerialization(ClassLoader classLoader) {
        try {
            Class<?> xStreamClass = Class.forName("com.thoughtworks.xstream.XStream");
            Class<?> generalDriverClass = Class.forName("com.thoughtworks.xstream.io.HierarchicalStreamDriver");
            Constructor<?> constructor = xStreamClass.getConstructor(generalDriverClass);
            Class<?> driverClass = Class.forName("com.thoughtworks.xstream.io.xml.XppDriver");
            this.xStream = (XStream)constructor.newInstance(driverClass.newInstance());
            this.xStream.setMode(1002);
            this.addAlias("IOContainer", IOContainer.class);
            this.addAlias("PolynominalAttribute", PolynominalAttribute.class);
            this.addAlias("BinominalAttribute", BinominalAttribute.class);
            this.addAlias("NumericalAttribute", NumericalAttribute.class);
            this.addAlias("PolynominalMapping", PolynominalMapping.class);
            this.addAlias("BinominalMapping", BinominalMapping.class);
            this.addAlias("NumericalStatistics", NumericalStatistics.class);
            this.addAlias("WeightedNumericalStatistics", WeightedNumericalStatistics.class);
            this.addAlias("NominalStatistics", NominalStatistics.class);
            this.addAlias("UnknownStatistics", UnknownStatistics.class);
            this.addAlias("SimpleAttributes", SimpleAttributes.class);
            this.addAlias("AttributeRole", AttributeRole.class);
            this.xStream.setClassLoader(classLoader);
        }
        catch (Throwable e) {
            LogService.getRoot().log(Level.WARNING, "Cannot initialize XML serialization. Probably the libraries 'xstream.jar' and 'xpp.jar' were not provided. XML serialization will not work!", e);
        }
    }

    public static void init(ClassLoader classLoader) {
        XMLSerialization.classLoader = classLoader;
    }

    public void addAlias(String name, Class clazz) {
        if (this.xStream != null) {
            String alias = name.replaceAll("[^a-zA-Z_0-9-]", "_").replaceAll("_+", "-");
            if (alias.endsWith("-")) {
                alias = alias.substring(0, alias.length() - 1);
            }
            this.xStream.alias(alias, clazz);
        }
    }

    public void writeXML(Object object, OutputStream out) throws IOException {
        if (this.xStream == null) {
            LogService.getRoot().warning("Cannot write XML serialization. Probably the libraries 'xstream.jar' and 'xpp.jar' were not provided.");
            throw new IOException("Cannot write object with XML serialization.");
        }
        ObjectOutputStream xOut = this.xStream.createObjectOutputStream((Writer)new OutputStreamWriter(out));
        xOut.writeObject(object);
        xOut.close();
    }

    public Object fromXML(InputStream in) throws IOException {
        if (this.xStream != null) {
            try {
                ObjectInputStream xIn = this.xStream.createObjectInputStream((Reader)new InputStreamReader(in));
                Object result = null;
                try {
                    result = xIn.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Class not found: " + e.getMessage(), e);
                }
                return result;
            }
            catch (Throwable e) {
                throw new IOException("Cannot read from XML stream, wrong format: " + e.getMessage(), e);
            }
        }
        LogService.getRoot().warning("Cannot read object from XML serialization. Probably the libraries 'xstream.jar' and 'xpp.jar' were not provided.");
        throw new IOException("Cannot read object from XML serialization.");
    }

    public static XMLSerialization getXMLSerialization() {
        return new XMLSerialization(classLoader);
    }
}

