/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.MailUtilities;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ResourceSource;
import com.rapidminer.tools.TimeFormat;
import com.rapidminer.tools.io.Encoding;
import com.rapidminer.tools.plugin.Plugin;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringEscapeUtils;

public class Tools {
    private static final String[] MEMORY_UNITS = new String[]{"b", "kB", "MB", "GB", "TB"};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final double IS_ZERO = 1.0E-6;
    private static final double IS_DISPLAY_ZERO = 1.0E-8;
    private static final TimeFormat DURATION_TIME_FORMAT = new TimeFormat();
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(1, Locale.getDefault());
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(2, Locale.getDefault());
    private static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
    private static Locale FORMAT_LOCALE = Locale.US;
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(FORMAT_LOCALE);
    private static NumberFormat INTEGER_FORMAT = NumberFormat.getIntegerInstance(FORMAT_LOCALE);
    private static NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance(FORMAT_LOCALE);
    private static DecimalFormatSymbols FORMAT_SYMBOLS = new DecimalFormatSymbols(FORMAT_LOCALE);
    private static final LinkedList<ResourceSource> ALL_RESOURCE_SOURCES = new LinkedList();
    public static final String RESOURCE_PREFIX = "com/rapidminer/resources/";
    public static String[] availableTimeZoneNames;
    public static final int SYSTEM_TIME_ZONE = 0;
    public static final String[] TRUE_STRINGS;
    public static final String[] FALSE_STRINGS;

    public static void setFormatLocale(Locale locale) {
        FORMAT_LOCALE = locale;
        NUMBER_FORMAT = NumberFormat.getInstance(locale);
        INTEGER_FORMAT = NumberFormat.getIntegerInstance(locale);
        PERCENT_FORMAT = NumberFormat.getPercentInstance(locale);
        FORMAT_SYMBOLS = new DecimalFormatSymbols(locale);
    }

    public static Locale getFormatLocale() {
        return FORMAT_LOCALE;
    }

    public static String[] getAllTimeZones() {
        return availableTimeZoneNames;
    }

    public static TimeZone getTimeZone(int index) {
        if (index == 0) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(availableTimeZoneNames[index]);
    }

    public static TimeZone getPreferredTimeZone() {
        return Tools.getTimeZone(Tools.getPreferredTimeZoneIndex());
    }

    public static int getPreferredTimeZoneIndex() {
        int preferredTimeZone;
        block5: {
            String timeZoneString = System.getProperty("rapidminer.general.timezone");
            preferredTimeZone = 0;
            try {
                if (timeZoneString != null) {
                    preferredTimeZone = Integer.parseInt(timeZoneString);
                }
            }
            catch (NumberFormatException e) {
                int index = 0;
                boolean found = false;
                for (String id : availableTimeZoneNames) {
                    if (id.equals(timeZoneString)) {
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (!found) break block5;
                preferredTimeZone = index;
            }
        }
        return preferredTimeZone;
    }

    public static Calendar getPreferredCalendar() {
        return Calendar.getInstance(Tools.getPreferredTimeZone(), Locale.getDefault());
    }

    public static String format(Object value, int valueType) {
        if (value == null) {
            return "?";
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
            return (String)value;
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2)) {
            return Tools.formatIntegerIfPossible((Double)value);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 10)) {
            return Tools.formatDate((Date)value);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 11)) {
            return Tools.formatTime((Date)value);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 9)) {
            return Tools.formatDateTime((Date)value);
        }
        return "?";
    }

    public static String formatPercent(double value) {
        if (Double.isNaN(value)) {
            return "?";
        }
        String percentDigitsString = System.getProperty("rapidminer.general.fractiondigits.percent");
        int percentDigits = 2;
        try {
            if (percentDigitsString != null) {
                percentDigits = Integer.parseInt(percentDigitsString);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Bad integer for property 'rapidminer.gui.fractiondigits.percent', using default number if digits (2).", 5);
        }
        PERCENT_FORMAT.setMaximumFractionDigits(percentDigits);
        PERCENT_FORMAT.setMinimumFractionDigits(percentDigits);
        return PERCENT_FORMAT.format(value);
    }

    public static String formatNumber(double value) {
        if (Double.isNaN(value)) {
            return "?";
        }
        int numberDigits = 3;
        try {
            String numberDigitsString = System.getProperty("rapidminer.general.fractiondigits.numbers");
            numberDigits = Integer.parseInt(numberDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Tools.formatNumber(value, numberDigits, false);
    }

    public static String formatNumber(double value, int numberOfDigits) {
        return Tools.formatNumber(value, numberOfDigits, false);
    }

    public static String formatNumber(double value, int numberOfDigits, boolean groupingCharacters) {
        if (Double.isNaN(value)) {
            return "?";
        }
        int numberDigits = numberOfDigits;
        if (numberDigits < 0) {
            try {
                String numberDigitsString = System.getProperty("rapidminer.general.fractiondigits.numbers");
                numberDigits = Integer.parseInt(numberDigitsString);
            }
            catch (NumberFormatException e) {
                numberDigits = 3;
            }
        }
        NUMBER_FORMAT.setMaximumFractionDigits(numberDigits);
        NUMBER_FORMAT.setMinimumFractionDigits(numberDigits);
        NUMBER_FORMAT.setGroupingUsed(groupingCharacters);
        return NUMBER_FORMAT.format(value);
    }

    public static String formatIntegerIfPossible(double value) {
        int numberDigits = 3;
        try {
            String numberDigitsString = System.getProperty("rapidminer.general.fractiondigits.numbers");
            numberDigits = Integer.parseInt(numberDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Tools.formatIntegerIfPossible(value, numberDigits, false);
    }

    public static String formatIntegerIfPossible(double value, int numberOfDigits) {
        return Tools.formatIntegerIfPossible(value, numberOfDigits, false);
    }

    public static String formatIntegerIfPossible(double value, int numberOfDigits, boolean groupingCharacter) {
        if (Double.isNaN(value)) {
            return "?";
        }
        if (Double.isInfinite(value)) {
            if (value < 0.0) {
                return "-" + FORMAT_SYMBOLS.getInfinity();
            }
            return FORMAT_SYMBOLS.getInfinity();
        }
        long longValue = Math.round(value);
        if (Math.abs((double)longValue - value) < 1.0E-8) {
            INTEGER_FORMAT.setGroupingUsed(groupingCharacter);
            return INTEGER_FORMAT.format(longValue);
        }
        return Tools.formatNumber(value, numberOfDigits, groupingCharacter);
    }

    public static String formatTime(Date date) {
        TIME_FORMAT.setTimeZone(Tools.getPreferredTimeZone());
        return TIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        DATE_FORMAT.setTimeZone(Tools.getPreferredTimeZone());
        return DATE_FORMAT.format(date);
    }

    public static String formatDateTime(Date date) {
        DATE_TIME_FORMAT.setTimeZone(Tools.getPreferredTimeZone());
        return DATE_TIME_FORMAT.format(date);
    }

    public static String formatDuration(long milliseconds) {
        return DURATION_TIME_FORMAT.format(milliseconds);
    }

    public static String ordinalNumber(int n) {
        if (n % 10 == 1 && n % 100 != 11) {
            return n + "st";
        }
        if (n % 10 == 2 && n % 100 != 12) {
            return n + "nd";
        }
        if (n % 10 == 3 && n % 100 != 13) {
            return n + "rd";
        }
        return n + "th";
    }

    public static boolean isEqual(double d1, double d2) {
        if (Double.isNaN(d1) && Double.isNaN(d2)) {
            return true;
        }
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            return false;
        }
        return Math.abs(d1 - d2) < 1.0E-6;
    }

    public static boolean isZero(double d) {
        return Tools.isEqual(d, 0.0);
    }

    public static boolean isNotEqual(double d1, double d2) {
        return !Tools.isEqual(d1, d2);
    }

    public static boolean isGreater(double d1, double d2) {
        return Double.compare(d1, d2) > 0 && Tools.isNotEqual(d1, d2) || Double.isNaN(d1) || Double.isNaN(d2);
    }

    public static boolean isGreaterEqual(double d1, double d2) {
        return Double.compare(d1, d2) > 0 || Tools.isEqual(d1, d2) || Double.isNaN(d1) || Double.isNaN(d2);
    }

    public static boolean isLess(double d1, double d2) {
        return !Tools.isGreaterEqual(d1, d2);
    }

    public static boolean isLessEqual(double d1, double d2) {
        return !Tools.isGreater(d1, d2) || Double.isNaN(d1) || Double.isNaN(d2);
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String getLineSeparators(int number) {
        if (number < 0) {
            number = 0;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            result.append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    public static String transformAllLineSeparators(String text) {
        Pattern crlf = Pattern.compile("(\r\n|\r|\n|\n\r)");
        Matcher m = crlf.matcher(text);
        if (m.find()) {
            text = m.replaceAll("\n");
        }
        return text;
    }

    public static String removeAllLineSeparators(String text) {
        Pattern crlf = Pattern.compile("(\r\n|\r|\n|\n\r)");
        Matcher m = crlf.matcher(text);
        if (m.find()) {
            text = m.replaceAll(" ");
        }
        return text;
    }

    @Deprecated
    public static String classNameWOPackage(Class c) {
        return c.getSimpleName();
    }

    public static String readOutput(BufferedReader in) throws IOException {
        StringBuffer output = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            output.append(line);
            output.append(Tools.getLineSeparator());
        }
        return output.toString();
    }

    public static File getFile(File parent, String name) {
        if (name == null) {
            return null;
        }
        File file = new File(name);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(parent, name);
    }

    public static BufferedReader getReader(File file, Charset encoding) throws IOException {
        if (file.getAbsolutePath().endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(file);
            if (zipFile.size() == 0) {
                throw new IOException("Input of Zip file failed: the file archive does not contain any entries.");
            }
            if (zipFile.size() > 1) {
                throw new IOException("Input of Zip file failed: the file archive contains more than one entry.");
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            InputStream zipIn = zipFile.getInputStream(entries.nextElement());
            return new BufferedReader(new InputStreamReader(zipIn, encoding));
        }
        if (file.getAbsolutePath().endsWith(".gz")) {
            return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), encoding));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
    }

    public static Charset getDefaultEncoding() {
        String encoding;
        ProcessRootOperator rootOperator;
        Process process;
        MainFrame mainFrame;
        Charset result = null;
        if (RapidMiner.getExecutionMode().hasMainFrame() && (mainFrame = RapidMinerGUI.getMainFrame()) != null && (process = mainFrame.getProcess()) != null && (rootOperator = process.getRootOperator()) != null) {
            try {
                result = Encoding.getEncoding(rootOperator);
            }
            catch (UndefinedParameterError e) {
                result = Charset.defaultCharset();
            }
            catch (UserError e) {
                result = Charset.defaultCharset();
            }
        }
        if (result == null && (encoding = System.getProperty("rapidminer.general.encoding")) != null && encoding.trim().length() > 0) {
            result = "SYSTEM".equals(encoding) ? Charset.defaultCharset() : Charset.forName(encoding);
        }
        if (result == null) {
            result = Charset.defaultCharset();
        }
        return result;
    }

    public static String getRelativePath(File firstFile, File secondFile) throws IOException {
        String canonicalFirstPath = firstFile.getCanonicalPath();
        String canonicalSecondPath = secondFile.getCanonicalPath();
        int minLength = Math.min(canonicalFirstPath.length(), canonicalSecondPath.length());
        int index = 0;
        for (index = 0; index < minLength && canonicalFirstPath.charAt(index) == canonicalSecondPath.charAt(index); ++index) {
        }
        String relPath = canonicalFirstPath;
        int lastSeparatorIndex = canonicalFirstPath.substring(0, index).lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            String absRest = canonicalSecondPath.substring(lastSeparatorIndex + 1);
            StringBuffer relPathBuffer = new StringBuffer();
            while (absRest.indexOf(File.separator) >= 0) {
                relPathBuffer.append(".." + File.separator);
                absRest = absRest.substring(absRest.indexOf(File.separator) + 1);
            }
            relPathBuffer.append(canonicalFirstPath.substring(lastSeparatorIndex + 1));
            relPath = relPathBuffer.toString();
        }
        return relPath;
    }

    public static void waitForProcess(Operator operator, java.lang.Process process, String name) throws OperatorException {
        try {
            LogService.getGlobal().log("Waiting for process '" + name + "' to die.", 0);
            int value = process.waitFor();
            if (value != 0) {
                throw new UserError(operator, 306, name, value);
            }
            LogService.getGlobal().log("Process '" + name + "' terminated successfully.", 2);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for process '" + name + "' to die.", e);
        }
    }

    @Deprecated
    public static void sendEmail(String address, String subject, String content) {
        MailUtilities.sendEmail(address, subject, content);
    }

    public static void addResourceSource(ResourceSource source) {
        ALL_RESOURCE_SOURCES.add(source);
    }

    public static void prependResourceSource(ResourceSource source) {
        ALL_RESOURCE_SOURCES.addFirst(source);
    }

    public static URL getResource(ClassLoader loader, String name) {
        return Tools.getResource(loader, RESOURCE_PREFIX, name);
    }

    public static URL getResource(ClassLoader loader, String prefix, String name) {
        return loader.getResource(prefix + name);
    }

    public static URL getResource(String name) {
        for (ResourceSource source : ALL_RESOURCE_SOURCES) {
            URL url = source.getResource(name);
            if (url == null) continue;
            return url;
        }
        URL resourceURL = Tools.getResource(Plugin.getMajorClassLoader(), name);
        if (resourceURL != null) {
            return resourceURL;
        }
        return null;
    }

    public static String readTextFile(InputStream in) throws IOException {
        return Tools.readTextFile(new InputStreamReader(in, "UTF-8"));
    }

    public static String readTextFile(File file) throws IOException {
        return Tools.readTextFile(new FileReader(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(Reader r) throws IOException {
        StringBuilder contents = new StringBuilder();
        BufferedReader reader = new BufferedReader(r);
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                contents.append(line + Tools.getLineSeparator());
            }
        }
        finally {
            reader.close();
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text) throws IOException {
        FileWriter out = new FileWriter(file);
        try {
            out.write(text);
        }
        finally {
            out.close();
        }
    }

    public static boolean booleanValue(String string, boolean deflt) {
        int i;
        if (string == null) {
            return deflt;
        }
        string = string.toLowerCase().trim();
        for (i = 0; i < TRUE_STRINGS.length; ++i) {
            if (!TRUE_STRINGS[i].equals(string)) continue;
            return true;
        }
        for (i = 0; i < FALSE_STRINGS.length; ++i) {
            if (!FALSE_STRINGS[i].equals(string)) continue;
            return false;
        }
        return deflt;
    }

    public static File findSourceFile(StackTraceElement e) {
        try {
            Class<?> clazz = Class.forName(e.getClassName());
            while (clazz.getDeclaringClass() != null) {
                clazz = clazz.getDeclaringClass();
            }
            String filename = clazz.getName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(filename + ".java");
        }
        catch (Throwable t) {
            String filename = e.getClassName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(filename + ".java");
        }
    }

    public static java.lang.Process launchFileEditor(File file, int line) throws IOException {
        String editor = System.getProperty("rapidminer.tools.editor");
        if (editor == null) {
            throw new IOException("Property 'rapidminer.tools.editor' undefined.");
        }
        editor = editor.replaceAll("%f", file.getAbsolutePath());
        editor = editor.replaceAll("%l", line + "");
        return Runtime.getRuntime().exec(editor);
    }

    public static String escapeXML(String string) {
        if (string == null) {
            return "null";
        }
        return StringEscapeUtils.escapeXml((String)string);
    }

    public static String escapeHTML(String string) {
        return StringEscapeUtils.escapeHtml((String)string);
    }

    public static void findImplementationsInJar(JarFile jar, Class superClass, List<String> implementations) {
        Tools.findImplementationsInJar(Tools.class.getClassLoader(), jar, superClass, implementations);
    }

    public static void findImplementationsInJar(ClassLoader loader, JarFile jar, Class<?> superClass, List<String> implementations) {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            int dotClass = name.lastIndexOf(".class");
            if (dotClass < 0) continue;
            name = name.substring(0, dotClass);
            name = name.replaceAll("/", "\\.");
            try {
                Class<?> c = loader.loadClass(name);
                if (!superClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                implementations.add(name);
            }
            catch (Throwable t) {}
        }
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                for (Plugin p : Plugin.getAllPlugins()) {
                    try {
                        return p.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                throw new ClassNotFoundException(className);
            }
        }
    }

    public static String[] quotedSplit(String line, Pattern separatorPattern) {
        return Tools.quotedSplit(line, separatorPattern, '\"', '\\');
    }

    public static String[] quotedSplit(String line, Pattern separatorPattern, char quotingChar, char escapeChar) {
        int[] quoteSplitIndices = new int[line.length()];
        char lastChar = '0';
        int lastSplitIndex = -1;
        for (int i = 0; i < line.length(); ++i) {
            char currentChar = line.charAt(i);
            if (currentChar == quotingChar) {
                boolean escaped = false;
                if (i != 0 && lastChar == escapeChar) {
                    escaped = true;
                }
                if (!escaped) {
                    quoteSplitIndices[++lastSplitIndex] = i;
                }
            }
            lastChar = currentChar;
        }
        LinkedList<String> quotedSplits = new LinkedList<String>();
        if (lastSplitIndex < 0) {
            line.replaceAll("\\\\\"", "\"");
            quotedSplits.add(line);
        } else {
            int start = 0;
            for (int i = 0; i <= lastSplitIndex; ++i) {
                int end = quoteSplitIndices[i];
                String part = "";
                if (end > start) {
                    part = line.substring(start, end);
                }
                part = part.replaceAll("\\\\\"", "\"");
                quotedSplits.add(part);
                start = end + 1;
            }
            if (start < line.length()) {
                String part = line.substring(start);
                part = part.replaceAll("\\\\\"", "\"");
                quotedSplits.add(part);
            }
        }
        LinkedList<String> result = new LinkedList<String>();
        boolean isSplitPart = true;
        int index = 0;
        for (String part : quotedSplits) {
            if (index > 0 || part.trim().length() > 0) {
                if (isSplitPart) {
                    String[] separatedParts = separatorPattern.split(part, -1);
                    for (int s = 0; s < separatedParts.length; ++s) {
                        String currentPart = separatedParts[s].trim();
                        if (currentPart.length() == 0) {
                            if (s == 0 && index == 0) {
                                result.add(currentPart);
                                continue;
                            }
                            if (s == separatedParts.length - 1 && index == quotedSplits.size() - 1) {
                                result.add(currentPart);
                                continue;
                            }
                            if (s <= 0 || s >= separatedParts.length - 1) continue;
                            result.add(currentPart);
                            continue;
                        }
                        result.add(currentPart);
                    }
                } else {
                    result.add(part);
                }
            }
            isSplitPart = !isSplitPart;
            ++index;
        }
        String[] resultArray = new String[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    @Deprecated
    public static String[] mergeQuotedSplits(String line, String[] splittedTokens, String quoteString) throws IOException {
        int[] tokenStarts = new int[splittedTokens.length];
        int currentCounter = 0;
        int currentIndex = 0;
        for (String currentToken : splittedTokens) {
            tokenStarts[currentIndex] = line.indexOf(currentToken, currentCounter);
            currentCounter = tokenStarts[currentIndex] + currentToken.length() + 1;
            ++currentIndex;
        }
        LinkedList<String> tokens = new LinkedList<String>();
        int start = -1;
        int end = -1;
        for (int i = 0; i < splittedTokens.length; ++i) {
            if (splittedTokens[i].trim().startsWith(quoteString)) {
                start = i;
            }
            if (start >= 0) {
                StringBuffer current = new StringBuffer();
                while (end < 0 && i < splittedTokens.length) {
                    if (splittedTokens[i].endsWith(quoteString)) {
                        end = i;
                        break;
                    }
                    ++i;
                }
                if (end < 0) {
                    throw new IOException("Error during reading: open quote \" is not ended!");
                }
                String lastToken = null;
                for (int a = start; a <= end; ++a) {
                    String nextToken = splittedTokens[a];
                    if (nextToken.length() == 0) continue;
                    if (a == start) {
                        nextToken = nextToken.substring(quoteString.length());
                    }
                    if (a == end) {
                        nextToken = nextToken.substring(0, nextToken.length() - quoteString.length());
                    }
                    if (lastToken != null) {
                        int lastIndex = tokenStarts[a - 1] + lastToken.length();
                        int thisIndex = tokenStarts[a];
                        if (lastIndex >= 0 && thisIndex >= lastIndex) {
                            String separator = line.substring(lastIndex, thisIndex);
                            current.append(separator);
                        }
                    }
                    current.append(nextToken);
                    lastToken = splittedTokens[a];
                }
                tokens.add(current.toString());
                start = -1;
                end = -1;
                continue;
            }
            tokens.add(splittedTokens[i]);
        }
        String[] quoted = new String[tokens.size()];
        tokens.toArray(quoted);
        return quoted;
    }

    public static void getFirstToken(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void getLastToken(StreamTokenizer tokenizer, boolean endOfFileOk) throws IOException {
        if (!(tokenizer.nextToken() == 10 || tokenizer.ttype == -1 && endOfFileOk)) {
            throw new IOException("expected the end of the line " + tokenizer.lineno());
        }
    }

    public static void getNextToken(StreamTokenizer tokenizer) throws IOException {
        if (tokenizer.nextToken() == 10) {
            throw new IOException("unexpected end of line " + tokenizer.lineno());
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("unexpected end of file in line " + tokenizer.lineno());
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void waitForEOL(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() != 10) {
        }
        tokenizer.pushBack();
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            File[] files;
            boolean success = true;
            for (File child : files = file.listFiles()) {
                success &= Tools.delete(child);
            }
            boolean result = file.delete();
            if (!result) {
                LogService.getRoot().warning("Unable to delete file " + file);
                return false;
            }
            return success;
        }
        boolean result = file.delete();
        if (!result) {
            LogService.getRoot().warning("Unable to delete file " + file);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            boolean result;
            if (!dstPath.exists() && !(result = dstPath.mkdir())) {
                throw new IOException("Unable to create directoy: " + dstPath);
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                Tools.copy(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else if (srcPath.exists()) {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(srcPath).getChannel();
                out = new FileOutputStream(dstPath).getChannel();
                long size = in.size();
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ((FileChannel)out).write(buf);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static String indent(int indent) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            s.append(" ");
        }
        return s.toString();
    }

    public static String formatBytes(long numberOfBytes) {
        if (numberOfBytes > 0x100000L) {
            long mBytes = numberOfBytes / 0x100000L;
            if (mBytes >= 100L) {
                return mBytes + " MB";
            }
            long remainder = (numberOfBytes - mBytes * 1024L * 1024L) / 1024L;
            return mBytes + "." + Long.toString(remainder).charAt(0) + " MB";
        }
        if (numberOfBytes > 1024L) {
            return numberOfBytes / 1024L + " kB";
        }
        return numberOfBytes + " bytes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamSynchronously(InputStream in, OutputStream out, boolean closeOutputStream) throws IOException {
        byte[] buffer = new byte[20480];
        try {
            int length;
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            out.flush();
            if (closeOutputStream) {
                out.close();
            }
        }
        finally {
            if (closeOutputStream && out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static String escape(String unescaped) {
        StringBuilder result = new StringBuilder();
        block5: for (char c : unescaped.toCharArray()) {
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block5;
                }
                case '\n': {
                    result.append("\\n");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String getExcelColumnName(int index) {
        if (index < 0) {
            return "error";
        }
        Character[] alphabet = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')};
        int quotient = index / 26;
        if (quotient > 0) {
            return Tools.getExcelColumnName(quotient - 1) + alphabet[index % 26].toString();
        }
        return alphabet[index % 26].toString();
    }

    public static String escapeQuoteCharsInQuotes(String line, Pattern separatorPattern, char quotingChar, char escapeChar, boolean showWarning) {
        char lastChar = '0';
        boolean openedQuote = false;
        LinkedList<Integer> rememberQuotePosition = new LinkedList<Integer>();
        for (int i = 0; i < line.length(); ++i) {
            if (lastChar == quotingChar) {
                if (openedQuote) {
                    boolean matches = Pattern.matches(separatorPattern.pattern() + ".*", line.substring(i));
                    if (matches) {
                        openedQuote = false;
                    } else {
                        rememberQuotePosition.add(i - 1);
                    }
                } else {
                    openedQuote = true;
                }
            }
            lastChar = line.charAt(i);
        }
        if (openedQuote && lastChar == quotingChar) {
            openedQuote = false;
        }
        if (showWarning && !rememberQuotePosition.isEmpty()) {
            StringBuilder positions = new StringBuilder();
            int j = 1;
            for (int i = 0; i < rememberQuotePosition.size(); ++i) {
                if (j % 10 == 0) {
                    positions.append("\n");
                }
                positions.append(rememberQuotePosition.get(i));
                if (i + 1 < rememberQuotePosition.size()) {
                    positions.append(", ");
                }
                ++j;
            }
            String lineBeginning = line;
            if (line.length() > 20) {
                lineBeginning = line.substring(0, 20);
            }
            String warning = "While reading the line starting with \n\n\t" + lineBeginning + "   ...\n\n" + ",an unescaped quote character was substituted by an escaped quote at the position(s) " + positions.toString() + ". " + "In particular der character '" + Character.toString(lastChar) + "' was replaced by '" + Character.toString(escapeChar) + Character.toString(lastChar) + ".";
            LogService.getGlobal().logWarning(warning);
        }
        if (!rememberQuotePosition.isEmpty()) {
            String newLine = "";
            int pos = (Integer)rememberQuotePosition.remove(0);
            int i = 0;
            char[] arr$ = line.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character c = Character.valueOf(arr$[i$]);
                if (i == pos) {
                    newLine = newLine + Character.toString(escapeChar) + c;
                    if (!rememberQuotePosition.isEmpty()) {
                        pos = (Integer)rememberQuotePosition.remove(0);
                    }
                } else {
                    newLine = newLine + c;
                }
                ++i;
            }
            line = newLine;
        }
        return line;
    }

    public static String unescape(String escaped) {
        StringBuilder result = new StringBuilder();
        block8: for (int index = 0; index < escaped.length(); ++index) {
            char c = escaped.charAt(index);
            switch (c) {
                case '\\': {
                    if (index < escaped.length() - 1) {
                        char next = escaped.charAt(++index);
                        switch (next) {
                            case 'n': {
                                result.append('\n');
                                continue block8;
                            }
                            case '\\': {
                                result.append('\\');
                                continue block8;
                            }
                            case '\"': {
                                result.append('\"');
                                continue block8;
                            }
                        }
                        result.append('\\').append(next);
                        continue block8;
                    }
                    result.append('\\');
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String toString(Collection<?> collection) {
        return Tools.toString(collection, ", ");
    }

    public static String toString(Collection<?> collection, String separator) {
        boolean first = true;
        StringBuilder b = new StringBuilder();
        for (Object o : collection) {
            if (first) {
                first = false;
            } else {
                b.append(separator);
            }
            b.append(o);
        }
        return b.toString();
    }

    public static String toString(Object[] collection) {
        return Tools.toString(collection, ", ");
    }

    public static String toString(Object[] collection, String separator) {
        if (collection == null) {
            return null;
        }
        return Tools.toString(Arrays.asList(collection), separator);
    }

    public static String formatSizeInBytes(long bytes) {
        long result;
        long rest = 0L;
        int unit = 0;
        for (result = bytes; result > 1024L; result /= 1024L) {
            rest = result % 1024L;
            if (++unit < MEMORY_UNITS.length - 1) continue;
        }
        if (result < 10L && unit > 0) {
            return result + "." + 10L * rest / 1024L + " " + MEMORY_UNITS[unit];
        }
        return result + " " + MEMORY_UNITS[unit];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readUrl(URL url) {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(url.openStream());
            class Part {
                byte[] partData;
                int len;

                Part() {
                }
            }
            LinkedList<Part> parts = new LinkedList<Part>();
            int len = 1;
            while (len > 0) {
                byte[] data = new byte[1024];
                len = in.read(data);
                if (len <= 0) continue;
                Part part = new Part();
                part.partData = data;
                part.len = len;
                parts.add(part);
            }
            int length = 0;
            for (Part part : parts) {
                length += part.len;
            }
            byte[] result = new byte[length];
            int pos = 0;
            for (Part part : parts) {
                System.arraycopy(part.partData, 0, result, pos, part.len);
                pos += part.len;
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String escape(String source, char escapeChar, char[] specialCharacters) {
        if (source == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (c == escapeChar) {
                b.append(escapeChar);
            } else {
                for (char s : specialCharacters) {
                    if (c != s) continue;
                    b.append(escapeChar);
                    break;
                }
            }
            b.append(c);
        }
        return b.toString();
    }

    public static List<String> unescape(String source, char escapeChar, char[] specialCharacters, char splitCharacter) {
        return Tools.unescape(source, escapeChar, specialCharacters, splitCharacter, -1);
    }

    public static List<String> unescape(String source, char escapeChar, char[] specialCharacters, char splitCharacter, int splitLimit) {
        LinkedList<String> result = new LinkedList<String>();
        StringBuilder b = new StringBuilder();
        boolean readEscape = false;
        int indexCount = -1;
        for (char c : source.toCharArray()) {
            ++indexCount;
            if (readEscape) {
                boolean found = false;
                if (c == splitCharacter) {
                    found = true;
                    b.append(c);
                } else if (c == escapeChar) {
                    found = true;
                    b.append(c);
                } else {
                    for (char s : specialCharacters) {
                        if (s != c) continue;
                        found = true;
                        b.append(c);
                        break;
                    }
                }
                if (!found) {
                    throw new IllegalArgumentException("String '" + source + "' contains illegal escaped character '" + c + "'.");
                }
                readEscape = false;
                continue;
            }
            if (c == escapeChar) {
                readEscape = true;
                continue;
            }
            if (c == splitCharacter) {
                readEscape = false;
                result.add(b.toString());
                if (splitLimit != -1 && result.size() == splitLimit - 1) {
                    result.add(source.substring(indexCount + 1));
                    return result;
                }
                b = new StringBuilder();
                continue;
            }
            readEscape = false;
            b.append(c);
        }
        result.add(b.toString());
        return result;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o1 == null && o2 == null;
    }

    static {
        ALL_RESOURCE_SOURCES.add(new ResourceSource(Tools.class.getClassLoader()));
        Object[] allTimeZoneNames = TimeZone.getAvailableIDs();
        Arrays.sort(allTimeZoneNames);
        availableTimeZoneNames = new String[allTimeZoneNames.length + 1];
        Tools.availableTimeZoneNames[0] = "SYSTEM";
        System.arraycopy(allTimeZoneNames, 0, availableTimeZoneNames, 1, allTimeZoneNames.length);
        TRUE_STRINGS = new String[]{"true", "on", "yes", "y"};
        FALSE_STRINGS = new String[]{"false", "off", "no", "n"};
    }
}

