/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeChar;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.LinkedList;
import java.util.List;

public class StrictDecimalFormat
extends DecimalFormat {
    private static final long serialVersionUID = -1597219600920760784L;
    public static final String PARAMETER_PARSE_NUMBERS = "parse_numbers";
    public static final String PARAMETER_DECIMAL_CHARACTER = "decimal_character";
    public static final String PARAMETER_GROUPED_DIGITS = "grouped_digits";
    public static final String PARAMETER_GROUPING_CHARACTER = "grouping_character";
    public static final char DEFAULT_DECIMAL_CHARACTER = '.';
    public static final char DEFAULT_GROUPING_CHARACTER = ',';

    public StrictDecimalFormat() {
        this.setParseIntegerOnly(false);
        this.setGroupingSize(3);
    }

    public StrictDecimalFormat(char decimalSeparator) {
        this();
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        symbols.setDecimalSeparator(decimalSeparator);
        this.setDecimalFormatSymbols(symbols);
        this.setGroupingUsed(false);
    }

    public StrictDecimalFormat(char decimalSeparator, char groupingSeparator) {
        this();
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        symbols.setDecimalSeparator(decimalSeparator);
        symbols.setGroupingSeparator(groupingSeparator);
        this.setDecimalFormatSymbols(symbols);
        this.setGroupingUsed(true);
    }

    @Override
    public Number parse(String source) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = this.parse(source, parsePosition);
        if (parsePosition.getIndex() < source.length()) {
            throw new ParseException("Unparseable number: \"" + source + "\"", parsePosition.getIndex());
        }
        return result;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        symbols.setDecimalSeparator(decimalSeparator);
        this.setDecimalFormatSymbols(symbols);
    }

    public void setGroupingSeparator(char groupingSeparator) {
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(groupingSeparator);
        this.setDecimalFormatSymbols(symbols);
    }

    public static StrictDecimalFormat getInstance(ParameterHandler handler) throws UndefinedParameterError {
        return StrictDecimalFormat.getInstance(handler, false);
    }

    public static StrictDecimalFormat getInstance(ParameterHandler handler, boolean optional) throws UndefinedParameterError {
        if (optional && !handler.getParameterAsBoolean(PARAMETER_PARSE_NUMBERS)) {
            return null;
        }
        char decimalCharacter = handler.getParameterAsChar(PARAMETER_DECIMAL_CHARACTER);
        char groupingCharacter = handler.getParameterAsChar(PARAMETER_GROUPING_CHARACTER);
        if (handler.getParameterAsBoolean(PARAMETER_GROUPED_DIGITS)) {
            return new StrictDecimalFormat(decimalCharacter, groupingCharacter);
        }
        return new StrictDecimalFormat(decimalCharacter);
    }

    public static List<ParameterType> getParameterTypes(ParameterHandler handler) {
        return StrictDecimalFormat.getParameterTypes(handler, false);
    }

    public static List<ParameterType> getParameterTypes(ParameterHandler handler, boolean optional) {
        ParameterTypeSingle type;
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        if (optional) {
            type = new ParameterTypeBoolean(PARAMETER_PARSE_NUMBERS, "Specifies whether numbers are parsed.", true, false);
            types.add(type);
        }
        type = new ParameterTypeChar(PARAMETER_DECIMAL_CHARACTER, "The decimal character.", '.', false);
        if (optional) {
            type.registerDependencyCondition(new BooleanParameterCondition(handler, PARAMETER_PARSE_NUMBERS, false, true));
        }
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_GROUPED_DIGITS, "Parse grouped digits.", false, false);
        if (optional) {
            type.registerDependencyCondition(new BooleanParameterCondition(handler, PARAMETER_PARSE_NUMBERS, false, true));
        }
        types.add(type);
        type = new ParameterTypeChar(PARAMETER_GROUPING_CHARACTER, "The grouping character.", ',', false);
        if (optional) {
            type.registerDependencyCondition(new BooleanParameterCondition(handler, PARAMETER_PARSE_NUMBERS, false, true));
        }
        type.registerDependencyCondition(new BooleanParameterCondition(handler, PARAMETER_GROUPED_DIGITS, false, true));
        types.add(type);
        return types;
    }
}

