/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.Process;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class RandomGenerator
extends Random {
    private static final long serialVersionUID = 7562534107359981433L;
    public static final String PARAMETER_USE_LOCAL_RANDOM_SEED = "use_local_random_seed";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static RandomGenerator globalRandomGenerator = new RandomGenerator(2001L);

    private RandomGenerator() {
    }

    public RandomGenerator(long seed) {
        super(seed);
    }

    public static RandomGenerator getGlobalRandomGenerator() {
        return RandomGenerator.getRandomGenerator(null, -1);
    }

    public static RandomGenerator getRandomGenerator(boolean useLocalGenerator, int localSeed) {
        return useLocalGenerator ? RandomGenerator.getRandomGenerator(null, localSeed) : RandomGenerator.getGlobalRandomGenerator();
    }

    public static RandomGenerator getRandomGenerator(Process process, int seed) {
        if (seed < 0) {
            if (globalRandomGenerator == null) {
                RandomGenerator.init(process);
            }
            return globalRandomGenerator;
        }
        return new RandomGenerator(seed);
    }

    public static void init(Process process) {
        long seed = 2001L;
        if (process != null) {
            try {
                seed = process.getRootOperator().getParameterAsInt("random_seed");
            }
            catch (UndefinedParameterError e) {
                seed = 2001L;
            }
        }
        globalRandomGenerator = seed == -1L ? new RandomGenerator() : new RandomGenerator(seed);
    }

    public static List<ParameterType> getRandomGeneratorParameters(Operator operator) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED, "Indicates if a local random seed should be used.", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Specifies the local random seed", 1, Integer.MAX_VALUE, 1992);
        type.registerDependencyCondition(new BooleanParameterCondition(operator, PARAMETER_USE_LOCAL_RANDOM_SEED, false, true));
        types.add(type);
        return types;
    }

    public static RandomGenerator getRandomGenerator(Operator operator) throws UndefinedParameterError {
        if (operator.getParameterAsBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED)) {
            return new RandomGenerator(operator.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        }
        return globalRandomGenerator;
    }

    public double nextDoubleInRange(double lowerBound, double upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextDoubleInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return this.nextDouble() * (upperBound - lowerBound) + lowerBound;
    }

    public long nextLongInRange(long lowerBound, long upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextLongInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return (long)(this.nextDouble() * (double)(upperBound - lowerBound + 1L)) + lowerBound;
    }

    public int nextIntInRange(int lowerBound, int upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextIntInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return this.nextInt(upperBound - lowerBound) + lowerBound;
    }

    public String nextString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = ALPHABET.charAt(this.nextInt(ALPHABET.length()));
        }
        return new String(chars);
    }

    public int randomIndex(double[] probs) {
        double r = this.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            if (!(r < (sum += probs[i]))) continue;
            return i;
        }
        return probs.length - 1;
    }

    public double[] nextDoubleArray(int length) {
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.nextDouble();
        }
        return values;
    }

    public Date nextDateInRange(Date start, Date end) {
        return new Date(this.nextLongInRange(start.getTime(), end.getTime()));
    }

    public Set<Integer> nextIntSetWithRange(int lowerBound, int upperBound, int size) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextIntInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        if (upperBound - lowerBound < size) {
            throw new IllegalArgumentException("RandomGenerator.nextIntInRange : impossible to deliver the desired set of integeres --> range is too small.");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < size) {
            set.add(this.nextIntInRange(lowerBound, upperBound));
        }
        return set;
    }
}

