/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.SettingsAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import java.awt.Desktop;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;

public class RMUrlHandler {
    public static final String URL_PREFIX = "rm://";
    public static final String PREFERENCES_URL = "rm://preferences";
    private static final Map<String, Action> ACTION_MAP = new HashMap<String, Action>();

    public static boolean handleUrl(String url) {
        if (url.startsWith(URL_PREFIX)) {
            String suffix = url.substring(URL_PREFIX.length());
            if (suffix.startsWith("opdoc/")) {
                String opName = suffix.substring("opdoc/".length());
                try {
                    Operator op = OperatorService.createOperator(opName);
                    RapidMinerGUI.getMainFrame().getOperatorDocViewer().setDisplayedOperator(op);
                }
                catch (OperatorCreationException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot create operator: " + opName, e);
                }
                return true;
            }
            if (suffix.startsWith("operator/")) {
                String opName = suffix.substring("operator/".length());
                MainFrame mainFrame = RapidMinerGUI.getMainFrame();
                mainFrame.selectOperator(mainFrame.getProcess().getOperator(opName));
                return true;
            }
            Action action = ACTION_MAP.get(suffix);
            if (action != null) {
                action.actionPerformed(null);
            } else {
                LogService.getRoot().warning("No action associated with URL " + url);
            }
            return true;
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception e) {
                SwingTools.showSimpleErrorMessage("cannot_open_browser", (Throwable)e, new Object[0]);
            }
            return true;
        }
        return false;
    }

    public static void register(String name, Action action) {
        ACTION_MAP.put(name, action);
    }

    static {
        RMUrlHandler.register("preferences", new SettingsAction());
    }
}

