/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.LogService;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ParentResolvingMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate = new HashMap();

    public void parseProperties(String resourceName, String prefix, String suffix, ClassLoader classLoader) throws IOException {
        Properties groupProps = new Properties();
        URL resource = classLoader.getResource(resourceName);
        if (resource == null) {
            LogService.getRoot().warning("Group properties resource '" + resourceName + "' not found.");
        } else {
            groupProps.load(resource.openStream());
            for (String propKey : groupProps.stringPropertyNames()) {
                if (!propKey.startsWith(prefix) || !propKey.endsWith(suffix)) continue;
                String keyString = propKey.substring(prefix.length());
                keyString = keyString.substring(0, keyString.length() - suffix.length());
                K mapKey = this.parseKey(keyString);
                V value = this.parseValue(groupProps.getProperty(propKey));
                this.delegate.put(mapKey, value);
            }
        }
    }

    public abstract V parseValue(String var1);

    public abstract K parseKey(String var1);

    public abstract K getParent(K var1);

    public abstract V getDefault();

    @Override
    public V get(Object key) {
        while (key != null) {
            V value = this.delegate.get(key);
            if (value != null) {
                return value;
            }
            key = this.getParent(key);
        }
        return this.getDefault();
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }
}

