/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapid_i.Launcher;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class ParameterService {
    public static final String PROPERTY_RAPIDMINER_SRC_ROOT = "rapidminer.src.root";
    private static final String ENVIRONMENT_RAPIDMINER_CONFIG_DIR = "RAPIDMINER_CONFIG_DIR";
    private static final String PROPERTY_RAPIDMINER_CONFIG_DIR = "rapidminer.config.dir";
    private static boolean intialized = false;

    public static void ensureRapidMinerHomeSet() {
        Launcher.ensureRapidMinerHomeSet();
    }

    public static void init() {
        ParameterService.init(null);
    }

    public static void init(InputStream operatorsXMLStream) {
        if (intialized) {
            return;
        }
        ParameterService.loadAllRCFiles();
        intialized = true;
    }

    public static void copyMainUserConfigFile(VersionNumber oldVersion, VersionNumber newVersion) {
        Properties oldProperties = ParameterService.readPropertyFile(ParameterService.getVersionedUserConfigFile(oldVersion, "rapidminerrc." + System.getProperty("os.name")));
        ParameterService.writeProperties(oldProperties, ParameterService.getMainUserConfigFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readPropertyFile(File file) {
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot read main user properties: " + e.getMessage(), e);
                return new Properties();
            }
            try {
                Properties properties = ParameterService.readPropertyFile(in);
                return properties;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        LogService.getRoot().log(Level.WARNING, "Cannot close connection to user properties: " + e.getMessage(), e);
                    }
                }
            }
        }
        return new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readPropertyFile(InputStream in) {
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot read main user properties: " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot close connection to user properties: " + e.getMessage(), e);
                }
            }
        }
        block11: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String typeKey = (String)entry.getKey();
            String typeValue = (String)entry.getValue();
            if (typeValue == null) continue;
            for (ParameterType type : RapidMiner.getRapidMinerProperties()) {
                if (!type.getKey().equals(typeKey)) continue;
                properties.put(typeKey, type.transformNewValue(typeValue));
                continue block11;
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(Properties properties, File file) {
        if (!RapidMiner.getExecutionMode().canAccessFilesystem()) {
            LogService.getRoot().config("Ignoring request to save properties file in execution mode " + (Object)((Object)RapidMiner.getExecutionMode()) + ".");
            return;
        }
        Properties writeableProperties = new Properties();
        for (ParameterType type : RapidMiner.getRapidMinerProperties()) {
            String value = (String)properties.get(type.getKey());
            if (value == null) continue;
            writeableProperties.setProperty(type.getKey(), value);
        }
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            writeableProperties.store(out, "");
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot write user properties: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void writePropertyIntoMainUserConfigFile(String key, String value) {
        if (!RapidMiner.getExecutionMode().canAccessFilesystem()) {
            LogService.getRoot().config("Ignoring request to save properties file in execution mode " + (Object)((Object)RapidMiner.getExecutionMode()) + ".");
            return;
        }
        LogService.getRoot().config("Saving property " + key + "=" + value);
        Properties userProperties = ParameterService.readPropertyFile(ParameterService.getMainUserConfigFile());
        userProperties.setProperty(key, value);
        System.setProperty(key, value);
        ParameterService.writeProperties(userProperties, ParameterService.getMainUserConfigFile());
    }

    public static File getMainUserConfigFile() {
        return ParameterService.getUserConfigFile("rapidminerrc." + System.getProperty("os.name"));
    }

    public static File getUserConfigFile(String name) {
        return ParameterService.getVersionedUserConfigFile(new VersionNumber(RapidMiner.getLongVersion()), name);
    }

    public static File getVersionedUserConfigFile(VersionNumber versionNumber, String name) {
        String configName = name;
        if (configName.startsWith("rapidminerrc") && versionNumber != null) {
            configName = versionNumber.toString().replaceAll("\\.", "_") + "_" + configName;
        }
        return new File(ParameterService.getUserRapidMinerDir(), configName);
    }

    public static File getUserRapidMinerDir() {
        File homeDir = new File(System.getProperty("user.home"));
        File userHomeDir = new File(homeDir, ".RapidMiner5");
        if (!userHomeDir.exists()) {
            LogService.getRoot().config("Creating directory '" + userHomeDir + "'.");
            boolean result = userHomeDir.mkdir();
            if (!result) {
                LogService.getRoot().warning("Unable to create user home rapidminer directory " + userHomeDir);
            }
        }
        return userHomeDir;
    }

    private static void loadAllRCFiles() {
        InputStream in = ParameterService.class.getResourceAsStream("/com/rapidminer/resources/rapidminerrc");
        if (in != null) {
            LogService.getRoot().config("Reading configuration resource com/rapidminer/resources/rapidminerrc.");
            Properties props = ParameterService.readPropertyFile(in);
            System.getProperties().putAll((Map<?, ?>)props);
        } else {
            LogService.getRoot().warning("Resource com/rapidminer/resources/rapidminerrc is missing.");
        }
        if (RapidMiner.getExecutionMode().canAccessFilesystem()) {
            File globalRC = ParameterService.getGlobalConfigFile("rapidminerrc");
            if (globalRC != null) {
                ParameterService.loadRCFile(globalRC.getAbsolutePath());
            }
            ParameterService.loadAllRCFiles(ParameterService.getUserConfigFile("rapidminerrc").getAbsolutePath());
            ParameterService.loadAllRCFiles(new File(new File(System.getProperty("user.dir")), "rapidminerrc").getAbsolutePath());
            String localRC = System.getProperty("rapidminer.rcfile");
            if (localRC != null) {
                ParameterService.loadRCFile(localRC);
            } else {
                LogService.getRoot().config("Property rapidminer.rcfile not specified...skipped");
            }
        } else {
            LogService.getRoot().config("Execution mode " + (Object)((Object)RapidMiner.getExecutionMode()) + " does not permit file access. Ignoring all rcfiles.");
        }
    }

    private static void loadAllRCFiles(String rcFileName) {
        ParameterService.loadRCFile(rcFileName);
        ParameterService.loadRCFile(rcFileName + "." + System.getProperty("os.name"));
    }

    private static void loadRCFile(String rcFileName) {
        if (rcFileName == null) {
            return;
        }
        File rcFile = new File(rcFileName);
        if (!rcFile.exists()) {
            LogService.getRoot().config("Trying rcfile '" + rcFile + "'...skipped");
            return;
        }
        Properties props = ParameterService.readPropertyFile(rcFile);
        System.getProperties().putAll((Map<?, ?>)props);
        LogService.getRoot().config("Read rcfile '" + rcFile + "'.");
    }

    public static File getRapidMinerHome() throws IOException {
        String property = System.getProperty("rapidminer.home");
        if (property == null) {
            throw new IOException("Property rapidminer.home is not set");
        }
        return new File(property);
    }

    public static File getLibraryFile(String name) throws IOException {
        File home = ParameterService.getRapidMinerHome();
        return new File(home, "lib" + File.separator + name);
    }

    public static boolean booleanValue(String value, boolean deflt) {
        if (value == null) {
            return deflt;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("yes")) {
            return true;
        }
        if (value.equals("y")) {
            return true;
        }
        if (value.equals("on")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("no")) {
            return false;
        }
        if (value.equals("n")) {
            return false;
        }
        if (value.equals("off")) {
            return false;
        }
        return deflt;
    }

    public static File getSourceRoot() {
        String srcName = System.getProperty(PROPERTY_RAPIDMINER_SRC_ROOT);
        if (srcName == null) {
            LogService.getRoot().warning("Property rapidminer.src.root not set.");
            return null;
        }
        return new File(srcName);
    }

    public static File getSourceFile(String name) {
        File root = ParameterService.getSourceRoot();
        if (root == null) {
            return null;
        }
        return new File(new File(root, "src"), name);
    }

    public static File getSourceResourceFile(String name) {
        File root = ParameterService.getSourceRoot();
        if (root == null) {
            return null;
        }
        return new File(new File(root, "resources"), name);
    }

    public static File getGlobalConfigFile(String fileName) {
        File dir = ParameterService.getGlobalConfigDir();
        if (dir != null) {
            File result = new File(dir, fileName);
            if (result.exists()) {
                if (result.canRead()) {
                    return result;
                }
                LogService.getRoot().warning("Config file " + result.getAbsolutePath() + " is not readable.");
                return null;
            }
            return null;
        }
        return null;
    }

    private static File getGlobalConfigDir() {
        String configDir = System.getProperty(PROPERTY_RAPIDMINER_CONFIG_DIR);
        if (configDir == null) {
            configDir = System.getenv(ENVIRONMENT_RAPIDMINER_CONFIG_DIR);
        }
        if (configDir != null) {
            File dir = new File(configDir);
            if (dir.exists()) {
                if (dir.canRead()) {
                    return dir;
                }
                LogService.getRoot().warning("Directory " + dir.getAbsolutePath() + " specified by environment variable " + ENVIRONMENT_RAPIDMINER_CONFIG_DIR + " is not readable.");
                return null;
            }
            LogService.getRoot().warning("Directory " + dir.getAbsolutePath() + " specified by environment variable " + ENVIRONMENT_RAPIDMINER_CONFIG_DIR + " does not exist.");
            return null;
        }
        LogService.getRoot().config("Neither system property 'rapidminer.config.dir' nor environment variable 'RAPIDMINER_CONFIG_DIR' not set. Ignored.");
        return null;
    }
}

