/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.RapidMiner;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.tools.OperatorCreationHook;
import com.rapidminer.tools.GenericOperatorFactory;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.XMLSerialization;
import com.rapidminer.tools.documentation.OperatorDocBundle;
import com.rapidminer.tools.plugin.Plugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OperatorService {
    public static final String RAPID_MINER_CORE_PREFIX = "RapidMiner Core";
    public static final String RAPID_MINER_CORE_NAMESPACE = "core";
    private static final String OPERATORS_XML = "OperatorsCore.xml";
    private static final Map<String, OperatorDescription> KEYS_TO_DESCRIPTIONS = new HashMap<String, OperatorDescription>();
    private static final Set<Class<? extends Operator>> REGISTERED_OPERATOR_CLASSES = new HashSet<Class<? extends Operator>>();
    private static final Map<String, Class<? extends IOObject>> IO_OBJECT_NAME_MAP = new TreeMap<String, Class<? extends IOObject>>();
    private static final Map<String, String> DEPRECATION_MAP = new HashMap<String, String>();
    private static final List<OperatorCreationHook> operatorCreationHooks = new LinkedList<OperatorCreationHook>();

    private static URL getMainOperators() {
        String resource;
        String operatorsXML = System.getProperty("rapidminer.init.operators");
        if (operatorsXML != null) {
            resource = operatorsXML;
            LogService.getRoot().config("Main operator descriptor overrideen by system property. Using " + operatorsXML + ".");
        } else {
            resource = "/com/rapidminer/resources/OperatorsCore.xml";
        }
        return OperatorService.class.getResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        URL mainOperators = OperatorService.getMainOperators();
        if (mainOperators == null) {
            LogService.getRoot().severe("Cannot find main operator description file com/rapidminer/resources/OperatorsCore.xml.");
        } else {
            OperatorService.registerOperators(mainOperators, null, null);
        }
        String additionalOperators = System.getProperty("rapidminer.operators.additional");
        if (additionalOperators != null && !additionalOperators.isEmpty()) {
            if (!RapidMiner.getExecutionMode().canAccessFilesystem()) {
                LogService.getRoot().config("Execution mode " + (Object)((Object)RapidMiner.getExecutionMode()) + " does not permit accessing the file system. Ignoring additional operator description files '" + additionalOperators + "'.");
            } else {
                LogService.getRoot().info("Loading additional operators specified by RapidMiner.PROPERTY_RAPIDMINER_OPERATORS_ADDITIONAL (" + additionalOperators + ")");
                String[] additionalOperatorFileNames = additionalOperators.split(File.pathSeparator);
                for (int i = 0; i < additionalOperatorFileNames.length; ++i) {
                    File additionalOperatorFile = new File(additionalOperatorFileNames[i]);
                    if (additionalOperatorFile.exists()) {
                        FileInputStream in = null;
                        try {
                            in = new FileInputStream(additionalOperatorFile);
                            OperatorService.registerOperators(additionalOperatorFile.getPath(), in, null);
                            continue;
                        }
                        catch (IOException e) {
                            LogService.getRoot().log(Level.SEVERE, "Cannot read '" + additionalOperatorFile + "'.", e);
                            continue;
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                    LogService.getRoot().severe("Cannot find operator description file '" + additionalOperatorFileNames[i] + "'");
                }
            }
        }
        Plugin.registerAllPluginOperators();
        LogService.getRoot().config("Number of registered operator classes: " + REGISTERED_OPERATOR_CLASSES.size() + "; number of registered operator descriptions: " + KEYS_TO_DESCRIPTIONS.size() + "; number of replacements: " + DEPRECATION_MAP.size());
    }

    public static void registerOperators(URL operatorsXML, ClassLoader classLoader, Plugin plugin) {
        InputStream inputStream;
        try {
            inputStream = operatorsXML.openStream();
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot open stream to operator description file " + operatorsXML + ": " + e, e);
            return;
        }
        OperatorService.registerOperators(OPERATORS_XML, inputStream, null, plugin);
    }

    public static void registerOperators(String name, InputStream operatorsXML, ClassLoader classLoader) {
        OperatorService.registerOperators(name, operatorsXML, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerOperators(String name, InputStream operatorsXML, ClassLoader classLoader, Plugin provider) {
        if (classLoader == null) {
            classLoader = OperatorService.class.getClassLoader();
        }
        LogService.getRoot().config("Loading operators from '" + name + "'.");
        String version = null;
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(operatorsXML);
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("operators")) {
                LogService.getRoot().severe("Operator description file '" + name + "': outermost tag must be <operators>!");
                return;
            }
            version = document.getDocumentElement().getAttribute("version");
            if (version.equals("5.0")) {
                OperatorService.parseOperators(document, classLoader, provider);
            } else {
                OperatorService.parseOperatorsPre5(document, classLoader, provider);
            }
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "Cannot read operator description file '" + name + "': no valid XML: " + e.getMessage(), e);
            return;
        }
        finally {
            try {
                operatorsXML.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void parseOperators(Document document, ClassLoader classLoader, Plugin provider) throws XMLException, OperatorCreationException {
        OperatorDocBundle bundle;
        String docBundle = document.getDocumentElement().getAttribute("docbundle");
        if (docBundle == null || docBundle.isEmpty()) {
            bundle = null;
            LogService.getRoot().warning("Operators for " + provider.getName() + " don't have an attached documentation.");
        } else {
            bundle = OperatorDocBundle.load(classLoader, docBundle);
        }
        OperatorService.parseOperators(GroupTree.ROOT, document.getDocumentElement(), classLoader, provider, bundle);
    }

    private static void parseOperators(GroupTree currentGroup, Element groupElement, ClassLoader classLoader, Plugin provider, OperatorDocBundle bundle) throws XMLException, OperatorCreationException {
        NodeList children = groupElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (childElement.getTagName().equals("group")) {
                String name = childElement.getAttribute("key");
                String icon = XMLTools.getTagContents(childElement, "icon");
                GroupTree newTree = name != null && !name.isEmpty() ? currentGroup.getOrCreateSubGroup(name, bundle) : currentGroup;
                if (icon != null && icon.length() > 0) {
                    newTree.setIconName(icon);
                } else if (newTree.getIconName() == null || newTree.getIconName().length() == 0) {
                    newTree.setIconName(currentGroup.getIconName());
                }
                OperatorService.parseOperators(newTree, childElement, classLoader, provider, bundle);
                continue;
            }
            if (childElement.getTagName().equals("operator")) {
                try {
                    OperatorDescription desc = new OperatorDescription(currentGroup, childElement, classLoader, provider, bundle);
                    OperatorService.registerOperator(desc);
                    if (desc.getReplacedKeys() == null) continue;
                    for (String replaces : desc.getReplacedKeys()) {
                        DEPRECATION_MAP.put(replaces, desc.getKey());
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot load operator class: " + e, e);
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot load operator class: " + e, e);
                    continue;
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Failed to register operator: " + e, e);
                    continue;
                }
                catch (AbstractMethodError e) {
                    LogService.getRoot().log(Level.WARNING, "Failed to register operator: " + e, e);
                    continue;
                }
            }
            if (childElement.getTagName().equals("factory")) {
                String factoryClassName = childElement.getTextContent();
                if (factoryClassName == null || factoryClassName.isEmpty()) {
                    LogService.getRoot().warning("Malformed operator descriptor: <factory> tag must contain class name!");
                    continue;
                }
                Class<?> factoryClass = null;
                try {
                    factoryClass = Class.forName(factoryClassName, true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    LogService.getRoot().warning("Operator factory class '" + factoryClassName + "' not found!");
                }
                if (factoryClass == null) continue;
                if (GenericOperatorFactory.class.isAssignableFrom(factoryClass)) {
                    GenericOperatorFactory factory = null;
                    try {
                        factory = (GenericOperatorFactory)factoryClass.newInstance();
                    }
                    catch (Exception e) {
                        LogService.getRoot().warning("Cannot instantiate operator factory class '" + factoryClass.getName() + "'!");
                    }
                    LogService.getRoot().config("Creating operators from factory " + factoryClassName);
                    try {
                        factory.registerOperators(classLoader, provider);
                    }
                    catch (Exception e) {
                        LogService.getRoot().log(Level.WARNING, "Error registering operators from " + factoryClass.getName() + e, e);
                    }
                    continue;
                }
                LogService.getRoot().warning("Malformed operator descriptor: Only subclasses of GenericOperatorFactory may be defined as class, was '" + factoryClassName + "'!");
                continue;
            }
            if (childElement.getTagName().equals("icon")) continue;
            throw new XMLException("Illegal tag in operator descrioption file: " + childElement.getTagName());
        }
    }

    private static void parseOperatorsPre5(Document document, ClassLoader classLoader, Plugin provider) {
        NodeList operatorTags = document.getDocumentElement().getElementsByTagName("operator");
        for (int i = 0; i < operatorTags.getLength(); ++i) {
            Element currentElement = (Element)operatorTags.item(i);
            try {
                OperatorService.parseOperatorPre5(currentElement, classLoader, provider);
                continue;
            }
            catch (Throwable e) {
                Attr currentNameAttr = currentElement.getAttributeNode("name");
                if (currentNameAttr != null) {
                    LogService.getRoot().log(Level.WARNING, "Cannot register '" + currentNameAttr.getValue() + "': " + e, e);
                    continue;
                }
                LogService.getRoot().log(Level.WARNING, "Cannot register '" + currentElement + "': " + e, e);
            }
        }
    }

    private static void parseOperatorPre5(Element operatorTag, ClassLoader classLoader, Plugin provider) throws Exception {
        Attr nameAttr = operatorTag.getAttributeNode("name");
        Attr classAttr = operatorTag.getAttributeNode("class");
        if (nameAttr == null) {
            throw new Exception("Missing name for <operator> tag");
        }
        if (classAttr == null) {
            throw new Exception("Missing class for <operator> tag");
        }
        String name = nameAttr.getValue();
        String deprecationString = operatorTag.getAttribute("deprecation");
        String group = operatorTag.getAttribute("group");
        String icon = operatorTag.getAttribute("icon");
        if (icon.isEmpty()) {
            icon = null;
        }
        String[] names = name.split(",");
        int i = 0;
        for (String opName : names) {
            if (i > 0) {
                deprecationString = "Replaced by " + names[0] + ".";
                DEPRECATION_MAP.put(opName, names[0]);
                OperatorDescription replacement = OperatorService.getOperatorDescription(names[0]);
                replacement.setIsReplacementFor(opName);
            }
            String name1 = opName.trim();
            OperatorDescription description = new OperatorDescription(classLoader, name1, name1, classAttr.getValue(), group, icon, deprecationString, provider);
            try {
                OperatorService.registerOperator(description);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to register operator " + description.getKey() + ": " + e, e);
            }
            ++i;
        }
    }

    public static void registerOperator(OperatorDescription description) throws OperatorCreationException {
        OperatorDescription oldDescription = KEYS_TO_DESCRIPTIONS.get(description.getName());
        if (oldDescription != null) {
            LogService.getRoot().warning("Operator key '" + description.getKey() + "' was already registered for class " + oldDescription.getOperatorClass().getName() + ". Overwriting with " + description.getOperatorClass() + ".");
        }
        KEYS_TO_DESCRIPTIONS.put(description.getKey(), description);
        REGISTERED_OPERATOR_CLASSES.add(description.getOperatorClass());
        Operator currentOperator = description.createOperatorInstance();
        currentOperator.assumePreconditionsSatisfied();
        currentOperator.transformMetaData();
        OperatorService.checkIOObjects(currentOperator.getInputPorts());
        OperatorService.checkIOObjects(currentOperator.getOutputPorts());
    }

    private static void checkIOObjects(Ports<? extends Port> ports) {
        LinkedList<Class<? extends IOObject>> result = new LinkedList<Class<? extends IOObject>>();
        for (Port port : ports.getAllPorts()) {
            if (port.getMetaData() == null) continue;
            result.add(port.getMetaData().getObjectClass());
        }
        OperatorService.registerIOObjects(result);
    }

    public static void registerIOObjects(Collection<Class<? extends IOObject>> objects) {
        for (Class<? extends IOObject> currentClass : objects) {
            String current = currentClass.getName();
            IO_OBJECT_NAME_MAP.put(current.substring(current.lastIndexOf(".") + 1), currentClass);
        }
    }

    public static Set<String> getIOObjectsNames() {
        return IO_OBJECT_NAME_MAP.keySet();
    }

    public static void defineXMLAliasPairs() {
        for (Map.Entry<String, Class<? extends IOObject>> entry : IO_OBJECT_NAME_MAP.entrySet()) {
            String objectName = entry.getKey();
            Class<? extends IOObject> objectClass = entry.getValue();
            XMLSerialization.getXMLSerialization().addAlias(objectName, objectClass);
        }
        for (String name : OperatorService.getOperatorNames()) {
            OperatorDescription description = OperatorService.getOperatorDescription(name);
            if (!AbstractPerformanceEvaluator.class.isAssignableFrom(description.getOperatorClass())) continue;
            Operator operator = null;
            try {
                operator = OperatorService.createOperator(name);
            }
            catch (OperatorCreationException e) {
                // empty catch block
            }
            if (operator == null) continue;
            AbstractPerformanceEvaluator evaluator = (AbstractPerformanceEvaluator)operator;
            List<PerformanceCriterion> criteria = evaluator.getCriteria();
            for (PerformanceCriterion criterion : criteria) {
                XMLSerialization.getXMLSerialization().addAlias(criterion.getName(), criterion.getClass());
            }
        }
    }

    public static Class<? extends IOObject> getIOObjectClass(String name) {
        return IO_OBJECT_NAME_MAP.get(name);
    }

    @Deprecated
    public static Set<String> getOperatorNames() {
        return KEYS_TO_DESCRIPTIONS.keySet();
    }

    public static Set<String> getOperatorKeys() {
        return KEYS_TO_DESCRIPTIONS.keySet();
    }

    public static GroupTree getGroups() {
        return GroupTree.ROOT;
    }

    public static OperatorDescription[] getOperatorDescriptions(Class clazz) {
        LinkedList<OperatorDescription> result = new LinkedList<OperatorDescription>();
        for (OperatorDescription current : KEYS_TO_DESCRIPTIONS.values()) {
            if (!current.getOperatorClass().equals(clazz)) continue;
            result.add(current);
        }
        OperatorDescription[] resultArray = new OperatorDescription[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static OperatorDescription getOperatorDescription(String key) {
        return KEYS_TO_DESCRIPTIONS.get(key);
    }

    public static Operator createOperator(String typeName) throws OperatorCreationException {
        OperatorDescription description = OperatorService.getOperatorDescription(typeName);
        if (description == null) {
            throw new OperatorCreationException(4, typeName, null);
        }
        return OperatorService.createOperator(description);
    }

    public static Operator createOperator(OperatorDescription description) throws OperatorCreationException {
        return description.createOperatorInstance();
    }

    public static <T extends Operator> T createOperator(Class<T> clazz) throws OperatorCreationException {
        OperatorDescription[] descriptions = OperatorService.getOperatorDescriptions(clazz);
        if (descriptions.length == 0) {
            throw new OperatorCreationException(4, clazz.getName(), null);
        }
        if (descriptions.length > 1) {
            LinkedList<OperatorDescription> nonDeprecated = new LinkedList<OperatorDescription>();
            for (OperatorDescription od : descriptions) {
                if (od.getDeprecationInfo() != null) continue;
                nonDeprecated.add(od);
            }
            if (nonDeprecated.size() > 1) {
                throw new OperatorCreationException(5, clazz.getName(), null);
            }
            return (T)((OperatorDescription)nonDeprecated.get(0)).createOperatorInstance();
        }
        return (T)descriptions[0].createOperatorInstance();
    }

    public static String getReplacementForDeprecatedClass(String deprecatedClass) {
        return DEPRECATION_MAP.get(deprecatedClass);
    }

    public static void setAdditionalOperatorDescriptors(String ... files) {
        if (files == null || files.length == 0) {
            System.setProperty("rapidminer.operators.additional", null);
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String file : files) {
            if (!first) {
                buf.append(File.pathSeparator);
            } else {
                first = false;
            }
            buf.append(file);
        }
        System.setProperty("rapidminer.operators.additional", buf.toString());
    }

    public static void addOperatorCreationHook(OperatorCreationHook operatorCreationHook) {
        operatorCreationHooks.add(operatorCreationHook);
    }

    public static void invokeCreationHooks(Operator operator) {
        for (OperatorCreationHook hook : operatorCreationHooks) {
            try {
                hook.operatorCreated(operator);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Error in operator creation hooK: " + e, e);
            }
        }
    }
}

