/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.operator.annotation.PolynomialExampleSetResourceConsumptionEstimator;
import com.rapidminer.operator.annotation.PolynomialFunction;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.tools.I18N;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OperatorResourceConsumptionHandler {
    private static final String OPERATORS_RESOURCE_CONSUMPTION = "OperatorsResourceConsumption.csv";
    private static final int RESOURCE_CONSUMPTION_CSV_SPLITPARTS = 11;
    private static Map<String, String[]> resourceMap;
    private static final Logger LOGGER;

    public static String[] getTimeConsumption(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must not be null!");
        }
        if (resourceMap.get(clazz.toString()) == null) {
            return null;
        }
        String[] savedString = resourceMap.get(clazz.toString());
        try {
            return new String[]{savedString[1], savedString[2], savedString[3], savedString[4], savedString[5]};
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static String[] getMemoryConsumption(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must not be null!");
        }
        if (resourceMap.get(clazz.toString()) == null) {
            return null;
        }
        String[] savedString = resourceMap.get(clazz.toString());
        try {
            return new String[]{savedString[6], savedString[7], savedString[8], savedString[9], savedString[10]};
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static ResourceConsumptionEstimator getResourceConsumptionEstimator(InputPort inputPort, Class clazz, AttributeSubsetSelector attributeSelector) {
        String[] timeConsumption = OperatorResourceConsumptionHandler.getTimeConsumption(clazz);
        String[] memoryConsumption = OperatorResourceConsumptionHandler.getMemoryConsumption(clazz);
        if (timeConsumption == null || memoryConsumption == null) {
            return null;
        }
        PolynomialFunction timeFunction = new PolynomialFunction(Double.parseDouble(timeConsumption[0]), Double.parseDouble(timeConsumption[1]), Double.parseDouble(timeConsumption[3]), Double.parseDouble(timeConsumption[2]), Double.parseDouble(timeConsumption[4]));
        PolynomialFunction memoryFunction = new PolynomialFunction(Double.parseDouble(memoryConsumption[0]), Double.parseDouble(memoryConsumption[1]), Double.parseDouble(memoryConsumption[3]), Double.parseDouble(memoryConsumption[2]), Double.parseDouble(memoryConsumption[4]));
        return new PolynomialExampleSetResourceConsumptionEstimator(inputPort, attributeSelector, timeFunction, memoryFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LOGGER = Logger.getLogger(OperatorResourceConsumptionHandler.class.getName());
        resourceMap = new HashMap<String, String[]>();
        InputStream is = null;
        String resource = "/com/rapidminer/resources/OperatorsResourceConsumption.csv";
        try {
            URL url = OperatorResourceConsumptionHandler.class.getResource(resource);
            if (url == null) {
                LOGGER.warning(I18N.getMessage(I18N.getErrorBundle(), "profiler.error.no_csv_file", OPERATORS_RESOURCE_CONSUMPTION));
            } else {
                String row;
                is = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                int i = 0;
                while ((row = reader.readLine()) != null) {
                    ++i;
                    if (row.trim().equals("") || row.trim().charAt(0) == '#') continue;
                    String[] splitString = row.trim().split(";");
                    if (splitString.length != 11) {
                        LOGGER.warning(I18N.getMessage(I18N.getErrorBundle(), "profiler.error.malformed_csv_file", OPERATORS_RESOURCE_CONSUMPTION, i));
                    }
                    resourceMap.put(splitString[0], splitString);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warning(e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOGGER.warning(e.getLocalizedMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

