/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.DummyObjectVisualizer;
import com.rapidminer.gui.ExampleVisualizer;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class ObjectVisualizerService {
    private static final DummyObjectVisualizer DUMMY_VISUALIZER = new DummyObjectVisualizer();
    private static final Map<Object, WeakReference<ObjectVisualizer>> visualizerMap = new WeakHashMap<Object, WeakReference<ObjectVisualizer>>();

    public static void addObjectVisualizer(Object target, ObjectVisualizer visualizer) {
        visualizerMap.put(target, new WeakReference<ObjectVisualizer>(visualizer));
    }

    public static ObjectVisualizer getVisualizerForObject(Object targetObject) {
        ObjectVisualizer capableVisualizer = null;
        WeakReference<ObjectVisualizer> visualizerReference = visualizerMap.get(targetObject);
        if (visualizerReference != null) {
            capableVisualizer = (ObjectVisualizer)visualizerReference.get();
        }
        if (capableVisualizer == null) {
            if (targetObject instanceof ExampleSet) {
                ExampleVisualizer visualizer = new ExampleVisualizer((ExampleSet)targetObject);
                ObjectVisualizerService.addObjectVisualizer(targetObject, visualizer);
                return visualizer;
            }
            return DUMMY_VISUALIZER;
        }
        return capableVisualizer;
    }
}

