/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberParser {
    public static double parse(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            s = s.replaceAll(",", ".");
            s = s.replaceAll("\u00bc", ".25");
            s = s.replaceAll("\u00bd", ".5");
            s = s.replaceAll("\u00be", ".75");
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e2) {
                Pattern p1;
                Matcher m1;
                Pattern p2 = Pattern.compile("[^0-9]*([[0-9.]\\.]+)\\s?-\\s?([[0-9]\\.]+)(.*)");
                Matcher m2 = p2.matcher(s);
                if (m2.matches()) {
                    try {
                        return (Double.parseDouble(m2.group(1)) + Double.parseDouble(m2.group(2))) / 2.0;
                    }
                    catch (NumberFormatException e3) {
                        // empty catch block
                    }
                }
                if ((m1 = (p1 = Pattern.compile("[^0-9]*([[0-9]\\.]+)(.*)")).matcher(s)).matches()) {
                    try {
                        return Double.parseDouble(m1.group(1));
                    }
                    catch (NumberFormatException e4) {
                        // empty catch block
                    }
                }
                return Double.NaN;
            }
        }
    }

    public static double parseDouble(String s) throws NumberFormatException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            if (s.equals("?")) {
                return Double.NaN;
            }
            throw new NumberFormatException();
        }
    }
}

