/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class NetTools {
    protected static final String ICON_PROTOCOLL = "icon";
    protected static final String RESOURCE_PROTOCOLL = "resource";
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (NetTools.ICON_PROTOCOLL.equals(protocol)) {
                        return new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL u) throws IOException {
                                URL resource = Tools.getResource("icons" + u.getPath());
                                if (resource != null) {
                                    return resource.openConnection();
                                }
                                throw new IOException("Icon not found.");
                            }
                        };
                    }
                    if (NetTools.RESOURCE_PROTOCOLL.equals(protocol)) {
                        return new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL u) throws IOException {
                                URL resource = Tools.getResource(u.getPath().substring(1, u.getPath().length()));
                                if (resource != null) {
                                    return resource.openConnection();
                                }
                                throw new IOException("Resource not found.");
                            }
                        };
                    }
                    return null;
                }
            });
            initialized = true;
        }
    }
}

