/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.RapidMiner;
import com.rapidminer.tools.DefaultMailSessionFactory;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.MailSender;
import com.rapidminer.tools.MailSenderSMTP;
import com.rapidminer.tools.MailSenderSendmail;
import com.rapidminer.tools.MailSessionFactory;
import java.util.Map;
import javax.mail.Session;

public class MailUtilities {
    private static MailSessionFactory mailFactory = new DefaultMailSessionFactory();

    public static void setMailSessionFactory(MailSessionFactory mailFactory) {
        MailUtilities.mailFactory = mailFactory;
    }

    public static void sendEmail(String address, String subject, String content) {
        MailUtilities.sendEmail(address, subject, content, null);
    }

    public static void sendEmail(String address, String subject, String content, Map<String, String> headers) {
        try {
            String method = System.getProperty("rapidminer.tools.mail.method");
            int methodIndex = -1;
            if (method != null) {
                try {
                    methodIndex = Integer.parseInt(method);
                }
                catch (NumberFormatException e) {
                    methodIndex = -1;
                    for (int i = 0; i < RapidMiner.PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES.length; ++i) {
                        if (!RapidMiner.PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES[i].equals(method)) continue;
                        methodIndex = i;
                        break;
                    }
                }
            }
            if (methodIndex == -1) {
                methodIndex = 1;
            }
            MailSender mailSender = null;
            switch (methodIndex) {
                case 1: {
                    mailSender = new MailSenderSMTP();
                    break;
                }
                case 0: {
                    mailSender = new MailSenderSendmail();
                    break;
                }
                default: {
                    LogService.getGlobal().log("Illegal send mail method: " + method + ".", 6);
                }
            }
            if (mailSender != null) {
                mailSender.sendEmail(address, subject, content, headers);
            }
        }
        catch (Exception e) {
            LogService.getGlobal().log("Cannot send mail to " + address + ": " + e, 6);
        }
    }

    public static Session makeSession() {
        return mailFactory.makeSession();
    }
}

